/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class ContextualizerTestCase {
    @Test
    public void test() throws Exception {
        Object original = new Object();
        final Object target = new Object();
        final Object result = new Object();
        final AtomicReference resultRef = new AtomicReference();
        final AtomicContextReference<Object> contextRef = new AtomicContextReference<Object>(original);
        Contextualizer contextualizer = Contextualizer.withContextProvider((Supplier)contextRef.provide(target));
        Runnable runner = new Runnable(){
            final /* synthetic */ ContextualizerTestCase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Assertions.assertThat((Object)contextRef.get()).isSameAs(target);
                resultRef.set(result);
            }
        };
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        contextualizer.contextualize(runner).run();
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        Assertions.assertThat(resultRef.get()).isSameAs(result);
        resultRef.set(null);
        ExceptionRunnable<Exception> exceptionRunner = new ExceptionRunnable<Exception>(this){
            final /* synthetic */ ContextualizerTestCase this$0;
            {
                this.this$0 = this$0;
            }

            public void run() throws Exception {
                Assertions.assertThat((Object)contextRef.get()).isSameAs(target);
                resultRef.set(result);
            }
        };
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        contextualizer.contextualize((ExceptionRunnable)exceptionRunner).run();
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        Assertions.assertThat(resultRef.get()).isSameAs(result);
        resultRef.set(null);
        Callable<Object> caller = new Callable<Object>(this){
            final /* synthetic */ ContextualizerTestCase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object call() {
                Assertions.assertThat((Object)contextRef.get()).isSameAs(target);
                return result;
            }
        };
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        Assertions.assertThat(contextualizer.contextualize((Callable)caller).call()).isSameAs(result);
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        Supplier<Object> supplier = new Supplier<Object>(this){
            final /* synthetic */ ContextualizerTestCase this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object get() {
                Assertions.assertThat((Object)contextRef.get()).isSameAs(target);
                return result;
            }
        };
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        Assertions.assertThat(contextualizer.contextualize((Supplier)supplier).get()).isSameAs(result);
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        ExceptionSupplier<Object, Exception> exceptionSupplier = new ExceptionSupplier<Object, Exception>(this){
            final /* synthetic */ ContextualizerTestCase this$0;
            {
                this.this$0 = this$0;
            }

            public Object get() {
                Assertions.assertThat((Object)contextRef.get()).isSameAs(target);
                return result;
            }
        };
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
        Assertions.assertThat((Object)contextualizer.contextualize((ExceptionSupplier)exceptionSupplier).get()).isSameAs(result);
        Assertions.assertThat((Object)contextRef.get()).isSameAs(original);
    }

    static class AtomicContextReference<T>
    implements ContextReference<T> {
        private AtomicReference<T> ref;

        AtomicContextReference(T initial) {
            this.ref = new AtomicReference<T>(initial);
        }

        public void accept(T value) {
            this.ref.set(value);
        }

        public T get() {
            return this.ref.get();
        }
    }
}

