/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.wildfly.clustering.context.ContextualExecutorService;
import org.wildfly.clustering.context.Contextualizer;

public class ContextualExecutorServiceTestCase {
    private final ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
    private final Contextualizer contextualizer = (Contextualizer)Mockito.mock(Contextualizer.class);
    private final ExecutorService subject = new ContextualExecutorService(this.executor, this.contextualizer);

    @AfterEach
    public void after() {
        Mockito.reset((Object[])new Object[]{this.executor, this.contextualizer});
    }

    @Test
    public void execute() {
        Runnable command = (Runnable)Mockito.mock(Runnable.class);
        Runnable contextualCommand = (Runnable)Mockito.mock(Runnable.class);
        Mockito.when((Object)this.contextualizer.contextualize((Runnable)Mockito.same((Object)command))).thenReturn((Object)contextualCommand);
        this.subject.execute(command);
        ((ExecutorService)Mockito.verify((Object)this.executor)).execute(contextualCommand);
    }

    @Test
    public void shutdown() {
        this.subject.shutdown();
        ((ExecutorService)Mockito.verify((Object)this.executor)).shutdown();
    }

    @Test
    public void shutdownNow() {
        List<Runnable> expected = List.of((Runnable)Mockito.mock(Runnable.class));
        Mockito.when(this.executor.shutdownNow()).thenReturn(expected);
        List<Runnable> result = this.subject.shutdownNow();
        Assertions.assertThat(result).isSameAs(expected);
    }

    @Test
    public void isShutdown() {
        Mockito.when((Object)this.executor.isShutdown()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Assertions.assertThat((boolean)this.subject.isShutdown()).isFalse();
        Assertions.assertThat((boolean)this.subject.isShutdown()).isTrue();
    }

    @Test
    public void isTerminated() {
        Mockito.when((Object)this.executor.isTerminated()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Assertions.assertThat((boolean)this.subject.isTerminated()).isFalse();
        Assertions.assertThat((boolean)this.subject.isTerminated()).isTrue();
    }

    @Test
    public void awaitTermination() throws InterruptedException {
        Mockito.when((Object)this.executor.awaitTermination(10L, TimeUnit.MINUTES)).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Assertions.assertThat((boolean)this.subject.awaitTermination(10L, TimeUnit.MINUTES)).isFalse();
        Assertions.assertThat((boolean)this.subject.awaitTermination(10L, TimeUnit.MINUTES)).isTrue();
    }

    @Test
    public void submitCallable() {
        Callable task = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask = (Callable)Mockito.mock(Callable.class);
        Future expected = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)this.contextualizer.contextualize(task)).thenReturn((Object)contextualTask);
        Mockito.when(this.executor.submit((Callable)Mockito.same((Object)contextualTask))).thenReturn((Object)expected);
        Future result = this.subject.submit(task);
        Assertions.assertThat(result).isSameAs((Object)expected);
    }

    @Test
    public void submitRunnableWithResult() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        Runnable contextualTask = (Runnable)Mockito.mock(Runnable.class);
        Future expected = (Future)Mockito.mock(Future.class);
        Object param = new Object();
        Mockito.when((Object)this.contextualizer.contextualize(task)).thenReturn((Object)contextualTask);
        Mockito.when(this.executor.submit((Runnable)Mockito.same((Object)contextualTask), Mockito.same((Object)param))).thenReturn((Object)expected);
        Future<Object> result = this.subject.submit(task, param);
        Assertions.assertThat(result).isSameAs((Object)expected);
    }

    @Test
    public void submit() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        Runnable contextualTask = (Runnable)Mockito.mock(Runnable.class);
        Future expected = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)this.contextualizer.contextualize(task)).thenReturn((Object)contextualTask);
        Mockito.when(this.executor.submit((Runnable)Mockito.same((Object)contextualTask))).thenReturn((Object)expected);
        Future<?> result = this.subject.submit(task);
        Assertions.assertThat(result).isSameAs((Object)expected);
    }

    @Test
    public void invokeAll() throws InterruptedException {
        Callable task1 = (Callable)Mockito.mock(Callable.class);
        Callable task2 = (Callable)Mockito.mock(Callable.class);
        Callable task3 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask1 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask2 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask3 = (Callable)Mockito.mock(Callable.class);
        ArgumentCaptor capturedTasks = ArgumentCaptor.forClass(List.class);
        List<Future> expected = List.of((Future)Mockito.mock(Future.class));
        Mockito.when((Object)this.contextualizer.contextualize(task1)).thenReturn((Object)contextualTask1);
        Mockito.when((Object)this.contextualizer.contextualize(task2)).thenReturn((Object)contextualTask2);
        Mockito.when((Object)this.contextualizer.contextualize(task3)).thenReturn((Object)contextualTask3);
        Mockito.when(this.executor.invokeAll((Collection)capturedTasks.capture())).thenReturn(expected);
        List result = this.subject.invokeAll(Arrays.asList(task1, task2, task3));
        Assertions.assertThat(result).isSameAs(expected);
        ((ListAssert)Assertions.assertThat((List)((List)capturedTasks.getValue())).isNotNull()).containsExactly((Object[])new Callable[]{contextualTask1, contextualTask2, contextualTask3});
    }

    @Test
    public void invokeAllWithTimeout() throws InterruptedException {
        Callable task1 = (Callable)Mockito.mock(Callable.class);
        Callable task2 = (Callable)Mockito.mock(Callable.class);
        Callable task3 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask1 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask2 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask3 = (Callable)Mockito.mock(Callable.class);
        ArgumentCaptor capturedTasks = ArgumentCaptor.forClass(List.class);
        List<Future> expected = List.of((Future)Mockito.mock(Future.class));
        Mockito.when((Object)this.contextualizer.contextualize(task1)).thenReturn((Object)contextualTask1);
        Mockito.when((Object)this.contextualizer.contextualize(task2)).thenReturn((Object)contextualTask2);
        Mockito.when((Object)this.contextualizer.contextualize(task3)).thenReturn((Object)contextualTask3);
        Mockito.when(this.executor.invokeAll((Collection)capturedTasks.capture(), Mockito.eq((long)10L), (TimeUnit)((Object)Mockito.same((Object)((Object)TimeUnit.MINUTES))))).thenReturn(expected);
        List result = this.subject.invokeAll(Arrays.asList(task1, task2, task3), 10L, TimeUnit.MINUTES);
        Assertions.assertThat(result).isSameAs(expected);
        ((ListAssert)Assertions.assertThat((List)((List)capturedTasks.getValue())).isNotNull()).containsExactly((Object[])new Callable[]{contextualTask1, contextualTask2, contextualTask3});
    }

    @Test
    public void invokeAny() throws InterruptedException, ExecutionException {
        Callable task1 = (Callable)Mockito.mock(Callable.class);
        Callable task2 = (Callable)Mockito.mock(Callable.class);
        Callable task3 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask1 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask2 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask3 = (Callable)Mockito.mock(Callable.class);
        ArgumentCaptor capturedTasks = ArgumentCaptor.forClass(List.class);
        Object expected = new Object();
        Mockito.when((Object)this.contextualizer.contextualize(task1)).thenReturn((Object)contextualTask1);
        Mockito.when((Object)this.contextualizer.contextualize(task2)).thenReturn((Object)contextualTask2);
        Mockito.when((Object)this.contextualizer.contextualize(task3)).thenReturn((Object)contextualTask3);
        Mockito.when(this.executor.invokeAny((Collection)capturedTasks.capture())).thenReturn(expected);
        Object result = this.subject.invokeAny(Arrays.asList(task1, task2, task3));
        Assertions.assertThat(result).isSameAs(expected);
        ((ListAssert)Assertions.assertThat((List)((List)capturedTasks.getValue())).isNotNull()).containsExactly((Object[])new Callable[]{contextualTask1, contextualTask2, contextualTask3});
    }

    @Test
    public void invokeAnyWithTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        Callable task1 = (Callable)Mockito.mock(Callable.class);
        Callable task2 = (Callable)Mockito.mock(Callable.class);
        Callable task3 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask1 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask2 = (Callable)Mockito.mock(Callable.class);
        Callable contextualTask3 = (Callable)Mockito.mock(Callable.class);
        ArgumentCaptor capturedTasks = ArgumentCaptor.forClass(List.class);
        Object expected = new Object();
        Mockito.when((Object)this.contextualizer.contextualize(task1)).thenReturn((Object)contextualTask1);
        Mockito.when((Object)this.contextualizer.contextualize(task2)).thenReturn((Object)contextualTask2);
        Mockito.when((Object)this.contextualizer.contextualize(task3)).thenReturn((Object)contextualTask3);
        Mockito.when(this.executor.invokeAny((Collection)capturedTasks.capture(), Mockito.eq((long)10L), (TimeUnit)((Object)Mockito.same((Object)((Object)TimeUnit.MINUTES))))).thenReturn(expected);
        Object result = this.subject.invokeAny(Arrays.asList(task1, task2, task3), 10L, TimeUnit.MINUTES);
        Assertions.assertThat(result).isSameAs(expected);
        ((ListAssert)Assertions.assertThat((List)((List)capturedTasks.getValue())).isNotNull()).containsExactly((Object[])new Callable[]{contextualTask1, contextualTask2, contextualTask3});
    }
}

