/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.function.Consumer;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Supplier;

public interface ContextReference<C>
extends java.util.function.Supplier<C>,
Consumer<C> {
    public static <C> ContextReference<C> fromThreadLocal(final ThreadLocal<C> threadLocal) {
        return new ContextReference<C>(){

            @Override
            public C get() {
                return threadLocal.get();
            }

            @Override
            public void accept(C value) {
                threadLocal.set(value);
            }
        };
    }

    default public java.util.function.Supplier<Context> provide(final C target) {
        return target != null ? new Supplier<Context>(){

            public Context get() {
                final Object existing = ContextReference.this.get();
                if (existing == target) {
                    return Context.EMPTY;
                }
                ContextReference.this.accept(target);
                return new Context(){

                    @Override
                    public void close() {
                        ContextReference.this.accept(existing);
                    }
                };
            }
        } : Supplier.of((Object)Context.EMPTY);
    }
}

