/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.function.Supplier;
import org.wildfly.clustering.function.Runner;

public interface Context<T>
extends Supplier<T>,
AutoCloseable {
    public static final Context<?> EMPTY = Context.of(null, (Runnable)Runner.empty());

    @Override
    public void close();

    public static <T> Context<T> empty() {
        return EMPTY;
    }

    public static <T> Context<T> of(final T value, final Runnable closeTask) {
        return new Context<T>(){

            @Override
            public T get() {
                return value;
            }

            @Override
            public void close() {
                closeTask.run();
            }
        };
    }
}

