/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public interface BiFunction<T, U, R>
extends java.util.function.BiFunction<T, U, R> {
    public static final BiFunction<?, ?, ?> FIRST = new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object value1, Object value2) {
            return value1;
        }
    };
    public static final BiFunction<?, ?, ?> SECOND = new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object value1, Object value2) {
            return value2;
        }
    };
    public static final BiFunction<?, ?, ?> NULL = new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object value1, Object value2) {
            return null;
        }
    };

    default public <V1, V2> BiFunction<V1, V2, R> compose(final Function<? super V1, ? extends T> before1, final Function<? super V2, ? extends U> before2) {
        return new BiFunction<V1, V2, R>(){

            @Override
            public R apply(V1 value1, V2 value2) {
                return BiFunction.this.apply(before1.apply(value1), before2.apply(value2));
            }
        };
    }

    @Override
    default public <V> BiFunction<T, U, V> andThen(final Function<? super R, ? extends V> after) {
        return new BiFunction<T, U, V>(){

            @Override
            public V apply(T value1, U value2) {
                return after.apply(BiFunction.this.apply(value1, value2));
            }
        };
    }

    default public BiFunction<T, U, R> withDefault(final Predicate<T> predicate1, final java.util.function.Supplier<T> defaultValue1, final Predicate<U> predicate2, final java.util.function.Supplier<U> defaultValue2) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return BiFunction.this.apply(predicate1.test(value1) ? value1 : defaultValue1.get(), predicate2.test(value2) ? value2 : defaultValue2.get());
            }
        };
    }

    default public BiFunction<T, U, R> orDefault(final BiPredicate<T, U> predicate, final java.util.function.Supplier<R> defaultResult) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return predicate.test(value1, value2) ? BiFunction.this.apply(value1, value2) : defaultResult.get();
            }
        };
    }

    public static <T extends R, U, R> BiFunction<T, U, R> first() {
        return FIRST;
    }

    public static <T, U, R> BiFunction<T, U, R> first(final Function<T, R> function) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return function.apply(value1);
            }
        };
    }

    public static <T, U extends R, R> BiFunction<T, U, R> second() {
        return SECOND;
    }

    public static <T, U, R> BiFunction<T, U, R> second(final Function<U, R> function) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                return function.apply(value2);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> of(final R result) {
        return result != null ? new BiFunction<T, U, R>(){

            @Override
            public R apply(T ignore1, U ignore2) {
                return result;
            }
        } : NULL;
    }

    public static <T, U, R> BiFunction<T, U, R> of(final java.util.function.Supplier<R> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new BiFunction<T, U, R>(){

            @Override
            public R apply(T ignore1, U ignore2) {
                return supplier.get();
            }
        } : NULL;
    }
}

