/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.Supplier;

public interface Callable<T>
extends java.util.concurrent.Callable<T> {
    default public <R> Callable<R> map(final Function<T, R> mapper) {
        return new Callable<R>(){

            @Override
            public R call() throws Exception {
                return mapper.apply(Callable.this.call());
            }
        };
    }

    public static Callable<Void> of(final Runnable runner) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                runner.run();
                return null;
            }
        };
    }

    public static <T> Callable<T> of(final Supplier<T> supplier) {
        return new Callable<T>(){

            @Override
            public T call() {
                return supplier.get();
            }
        };
    }
}

