/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wildfly.clustering.function.BinaryOperator;

public interface Consumer<T>
extends java.util.function.Consumer<T> {
    public static final Consumer<?> EMPTY = new Consumer<Object>(){

        @Override
        public void accept(Object value) {
        }
    };
    public static final Map<System.Logger.Level, Consumer<Exception>> EXCEPTION_LOGGERS = EnumSet.allOf(System.Logger.Level.class).stream().collect(Collectors.toMap(Function.identity(), ExceptionLogger::new, BinaryOperator.former(), () -> new EnumMap(System.Logger.Level.class)));
    public static final Function<System.Logger.Level, Consumer<Exception>> EXCEPTION_LOGGER = EXCEPTION_LOGGERS::get;
    public static final Map<System.Logger.Level, Consumer<AutoCloseable>> SILENT_CLOSERS = EnumSet.allOf(System.Logger.Level.class).stream().collect(Collectors.toMap(Function.identity(), EXCEPTION_LOGGER.andThen(Consumer::close), BinaryOperator.former(), () -> new EnumMap(System.Logger.Level.class)));

    @Override
    default public Consumer<T> andThen(java.util.function.Consumer<? super T> after) {
        return Consumer.of(List.of(this, after));
    }

    default public <V> Consumer<V> compose(final Function<V, T> mapper) {
        return new Consumer<V>(){

            @Override
            public void accept(V value) {
                Consumer.this.accept(mapper.apply(value));
            }
        };
    }

    public static <V> Consumer<V> empty() {
        return EMPTY;
    }

    public static <V extends AutoCloseable> Consumer<V> close() {
        return Consumer.close(Consumer.warning());
    }

    public static Consumer<Exception> log(System.Logger.Level level) {
        return EXCEPTION_LOGGER.apply(level);
    }

    public static Consumer<Exception> error() {
        return Consumer.log(System.Logger.Level.ERROR);
    }

    public static Consumer<Exception> warning() {
        return Consumer.log(System.Logger.Level.WARNING);
    }

    public static Consumer<Exception> info() {
        return Consumer.log(System.Logger.Level.INFO);
    }

    public static Consumer<Exception> debug() {
        return Consumer.log(System.Logger.Level.DEBUG);
    }

    public static <V extends AutoCloseable> Consumer<V> close(final Consumer<Exception> handler) {
        return new Consumer<V>(){

            @Override
            public void accept(AutoCloseable object) {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception e) {
                        handler.accept(e);
                    }
                }
            }
        };
    }

    public static <V> Consumer<V> of(final Runnable task) {
        return new Consumer<V>(){

            @Override
            public void accept(V ignored) {
                task.run();
            }
        };
    }

    public static <V> Consumer<V> of(final Iterable<java.util.function.Consumer<? super V>> consumers) {
        return new Consumer<V>(){

            @Override
            public void accept(V value) {
                for (java.util.function.Consumer consumer : consumers) {
                    consumer.accept(value);
                }
            }
        };
    }

    public static class ExceptionLogger
    implements Consumer<Exception> {
        private static final System.Logger LOGGER = System.getLogger(Consumer.class.getName());
        private final System.Logger.Level level;

        ExceptionLogger(System.Logger.Level level) {
            this.level = level;
        }

        @Override
        public void accept(Exception exception) {
            if (exception != null) {
                LOGGER.log(this.level, exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

