/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.BiFunction;

public class BiFunctionTestCase {
    private Object value1 = new Object();
    private Object value2 = new Object();
    private Object result = new Object();

    @Test
    public void empty() {
        BiFunction function = BiFunction.empty();
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    public void of() {
        BiFunction function = BiFunction.of((Object)this.result);
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.result);
        function = BiFunction.of(null);
        result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    public void get() {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)this.result).when((Object)supplier)).get();
        BiFunction function = BiFunction.get((Supplier)supplier);
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.result);
        function = BiFunction.get(null);
        result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    public void formerValue() {
        BiFunction function = BiFunction.former();
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.value1);
    }

    @Test
    public void latterValue() {
        BiFunction function = BiFunction.latter();
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.value2);
    }

    @Test
    public void formerFunction() {
        Function function1 = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doReturn((Object)this.result).when((Object)function1)).apply(this.value1);
        BiFunction function = BiFunction.former((Function)function1);
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.result);
    }

    @Test
    public void latterFunction() {
        Function function2 = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doReturn((Object)this.result).when((Object)function2)).apply(this.value2);
        BiFunction function = BiFunction.latter((Function)function2);
        Object result = function.apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.result);
    }

    @Test
    public void andThen() {
        Object interrimResult = new Object();
        BiFunction before = (BiFunction)Mockito.mock(BiFunction.class);
        Function after = (Function)Mockito.mock(Function.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)before)).andThen((Function)Mockito.any());
        ((BiFunction)Mockito.doReturn((Object)interrimResult).when((Object)before)).apply(this.value1, this.value2);
        ((Function)Mockito.doReturn((Object)this.result).when((Object)after)).apply(interrimResult);
        Object result = before.andThen(after).apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.result);
    }

    @Test
    public void compose() {
        Object interrimResult1 = new Object();
        Object interrimResult2 = new Object();
        BiFunction after = (BiFunction)Mockito.mock(BiFunction.class);
        Function before1 = (Function)Mockito.mock(Function.class);
        Function before2 = (Function)Mockito.mock(Function.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)after)).compose((Function)Mockito.any(), (Function)Mockito.any());
        ((Function)Mockito.doReturn((Object)interrimResult1).when((Object)before1)).apply(this.value1);
        ((Function)Mockito.doReturn((Object)interrimResult2).when((Object)before2)).apply(this.value2);
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)after)).apply(interrimResult1, interrimResult2);
        Object result = after.compose(before1, before2).apply(this.value1, this.value2);
        Assertions.assertThat((Object)result).isSameAs(this.result);
    }

    @Test
    public void reverse() {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)function)).apply(this.value1, this.value2);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)function)).reverse();
        Object result = function.reverse().apply(this.value2, this.value1);
        Assertions.assertThat((Object)result).isSameAs(this.result);
    }

    @Test
    public void withDefault() {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)function)).withDefault((Predicate)Mockito.any(), (Supplier)Mockito.any(), (Predicate)Mockito.any(), (Supplier)Mockito.any());
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier1 = (Supplier)Mockito.mock(Supplier.class);
        Supplier supplier2 = (Supplier)Mockito.mock(Supplier.class);
        Object expectedWhenDefaultValue1 = new Object();
        Object expectedWhenDefaultValue2 = new Object();
        Object expectedWhenDefaultValues = new Object();
        Object defaultValue1 = new Object();
        Object defaultValue2 = new Object();
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate1)).test(this.value1);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate2)).test(this.value2);
        ((Supplier)Mockito.doReturn((Object)defaultValue1).when((Object)supplier1)).get();
        ((Supplier)Mockito.doReturn((Object)defaultValue2).when((Object)supplier2)).get();
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)function)).apply(this.value1, this.value2);
        ((BiFunction)Mockito.doReturn((Object)expectedWhenDefaultValues).when((Object)function)).apply(defaultValue1, defaultValue2);
        ((BiFunction)Mockito.doReturn((Object)expectedWhenDefaultValue1).when((Object)function)).apply(defaultValue1, this.value2);
        ((BiFunction)Mockito.doReturn((Object)expectedWhenDefaultValue2).when((Object)function)).apply(this.value1, defaultValue2);
        Assertions.assertThat((Object)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply(this.value1, this.value2)).isSameAs(expectedWhenDefaultValues);
        Assertions.assertThat((Object)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply(this.value1, this.value2)).isSameAs(expectedWhenDefaultValue1);
        Assertions.assertThat((Object)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply(this.value1, this.value2)).isSameAs(expectedWhenDefaultValue2);
        Assertions.assertThat((Object)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply(this.value1, this.value2)).isSameAs(this.result);
    }

    @Test
    public void orDefault() {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)function)).orDefault((BiPredicate)Mockito.any(), (Supplier)Mockito.any());
        BiPredicate predicate = (BiPredicate)Mockito.mock(BiPredicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Object defaultValue = new Object();
        ((BiPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(this.value1, this.value2);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)function)).apply(this.value1, this.value2);
        Assertions.assertThat((Object)function.orDefault(predicate, supplier).apply(this.value1, this.value2)).isSameAs(defaultValue);
        Assertions.assertThat((Object)function.orDefault(predicate, supplier).apply(this.value1, this.value2)).isSameAs(this.result);
    }
}

