/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public class FunctionTestCase {
    @Test
    public void empty() {
        Assertions.assertThat((Object)Function.empty().apply(new Object())).isNull();
    }

    @Test
    public void of() {
        Object expected = new Object();
        Assertions.assertThat((Object)Function.of((Object)expected).apply(new Object())).isSameAs(expected);
        Assertions.assertThat((Object)Function.of(null).apply(new Object())).isNull();
    }

    @Test
    public void get() {
        Object expected = new Object();
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        Assertions.assertThat((Object)Function.get((java.util.function.Supplier)supplier).apply(new Object())).isSameAs(expected);
        Assertions.assertThat((Object)Function.get(null).apply(new Object())).isNull();
    }

    @Test
    public void withDefault() {
        Object result = new Object();
        Object value = new Object();
        Object defaultValue = new Object();
        Object defaultResult = new Object();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).withDefault((java.util.function.Predicate)Mockito.any(), (java.util.function.Supplier)Mockito.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(value);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply(value);
        ((Function)Mockito.doReturn((Object)defaultResult).when((Object)function)).apply(defaultValue);
        Assertions.assertThat((Object)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(defaultResult);
        Assertions.assertThat((Object)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(result);
    }

    @Test
    public void orDefault() {
        Object result = new Object();
        Object value = new Object();
        Object defaultResult = new Object();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).orDefault((java.util.function.Predicate)Mockito.any(), (java.util.function.Supplier)Mockito.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(value);
        ((Supplier)Mockito.doReturn((Object)defaultResult).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply(value);
        Assertions.assertThat((Object)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(defaultResult);
        Assertions.assertThat((Object)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(result);
    }

    @Test
    public void handle() {
        Function function = (Function)Mockito.mock(Function.class);
        BiFunction handler = (BiFunction)Mockito.mock(BiFunction.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).handle((java.util.function.BiFunction)Mockito.any());
        Object goodValue = new Object();
        Object badValue = new Object();
        Object result = new Object();
        Object handled = new Object();
        RuntimeException exception = new RuntimeException();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply(goodValue);
        ((Function)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)function)).apply(badValue);
        ((BiFunction)Mockito.doReturn((Object)handled).when((Object)handler)).apply(badValue, (Object)exception);
        Assertions.assertThat((Object)function.handle((java.util.function.BiFunction)handler).apply(goodValue)).isSameAs(result);
        Assertions.assertThat((Object)function.handle((java.util.function.BiFunction)handler).apply(badValue)).isSameAs(handled);
        ((Function)Mockito.verify((Object)function)).apply(goodValue);
        ((Function)Mockito.verify((Object)function)).apply(badValue);
        ((BiFunction)Mockito.verify((Object)handler)).apply(badValue, (Object)exception);
    }
}

