/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiPredicate;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;

public class PredicateTestCase {
    @Test
    public void test() {
        Assertions.assertThat((boolean)Predicate.always().test(new Object())).isTrue();
        Assertions.assertThat((boolean)Predicate.always().test(null)).isTrue();
        Assertions.assertThat((boolean)Predicate.never().test(new Object())).isFalse();
        Assertions.assertThat((boolean)Predicate.never().test(null)).isFalse();
        Assertions.assertThat((boolean)Predicate.of((boolean)true).test(new Object())).isTrue();
        Assertions.assertThat((boolean)Predicate.of((boolean)true).test(null)).isTrue();
        Assertions.assertThat((boolean)Predicate.of((boolean)false).test(new Object())).isFalse();
        Assertions.assertThat((boolean)Predicate.of((boolean)false).test(null)).isFalse();
    }

    @Test
    public void negate() {
        Assertions.assertThat((boolean)Predicate.always().negate().test(new Object())).isFalse();
        Assertions.assertThat((boolean)Predicate.always().negate().test(null)).isFalse();
        Assertions.assertThat((boolean)Predicate.never().negate().test(new Object())).isTrue();
        Assertions.assertThat((boolean)Predicate.never().negate().test(null)).isTrue();
    }

    @Test
    public void compose() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Function composer = (Function)Mockito.mock(Function.class);
        Object value = new Object();
        Object mapped = new Object();
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).compose((java.util.function.Function)ArgumentMatchers.any());
        ((Function)Mockito.doReturn((Object)mapped).when((Object)composer)).apply(value);
        ((Predicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.compose((java.util.function.Function)composer).test(value)).isTrue();
        ((Predicate)Mockito.verify((Object)predicate, (VerificationMode)Mockito.never())).test(value);
    }

    @Test
    public void handle() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        BiPredicate handler = (BiPredicate)Mockito.mock(BiPredicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).handle((java.util.function.BiPredicate)Mockito.any());
        Object goodValue = new Object();
        Object badValue = new Object();
        RuntimeException exception = new RuntimeException();
        ((Predicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(goodValue);
        ((Predicate)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)predicate)).test(badValue);
        ((BiPredicate)Mockito.doReturn((Object)true).when((Object)handler)).test(badValue, (Object)exception);
        Assertions.assertThat((boolean)predicate.handle((java.util.function.BiPredicate)handler).test(goodValue)).isFalse();
        Assertions.assertThat((boolean)predicate.handle((java.util.function.BiPredicate)handler).test(badValue)).isTrue();
        ((Predicate)Mockito.verify((Object)predicate)).test(goodValue);
        ((Predicate)Mockito.verify((Object)predicate)).test(badValue);
        ((BiPredicate)Mockito.verify((Object)handler)).test(badValue, (Object)exception);
    }
}

