/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.Supplier;

public class RunnableTestCase {
    @Test
    public void andThen() {
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{runner1, runner2});
        ((Runnable)Mockito.doCallRealMethod().when((Object)runner1)).andThen((java.lang.Runnable)Mockito.any());
        runner1.andThen((java.lang.Runnable)runner2).run();
        ((Runnable)order.verify((Object)runner1)).run();
        ((Runnable)order.verify((Object)runner2)).run();
    }

    @Test
    public void handle() {
        Runnable runner = (Runnable)Mockito.mock(Runnable.class);
        Consumer handler = (Consumer)Mockito.mock(Consumer.class);
        RuntimeException exception = new RuntimeException();
        ((Runnable)Mockito.doCallRealMethod().when((Object)runner)).handle((Consumer)Mockito.any());
        runner.handle(handler).run();
        ((Runnable)Mockito.verify((Object)runner)).run();
        ((Consumer)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).accept((Object)((RuntimeException)Mockito.any()));
        ((Runnable)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)runner)).run();
        runner.handle(handler).run();
        ((Consumer)Mockito.verify((Object)handler)).accept((Object)exception);
    }

    @Test
    public void composite() {
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner3 = (Runnable)Mockito.mock(Runnable.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{runner1, runner2, runner3});
        Runnable.runAll(List.of(runner1, runner2, runner3)).run();
        ((Runnable)order.verify((Object)runner1)).run();
        ((Runnable)order.verify((Object)runner2)).run();
        ((Runnable)order.verify((Object)runner3)).run();
    }

    @Test
    public void acceptProvided() {
        Object value = new Object();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Runnable.accept((java.util.function.Consumer)consumer, (java.util.function.Supplier)Supplier.of((Object)value)).run();
        ((Consumer)Mockito.verify((Object)consumer)).accept(value);
    }
}

