/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Callable;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.Supplier;

public class SupplierTestCase {
    @Test
    public void map() {
        Object interrim = new Object();
        Object expected = new Object();
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).map((java.util.function.Function)Mockito.any());
        ((Supplier)Mockito.doReturn((Object)interrim).when((Object)supplier)).get();
        Function mapper = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doReturn((Object)expected).when((Object)mapper)).apply(interrim);
        Object result = supplier.map((java.util.function.Function)mapper).get();
        Assertions.assertThat((Object)result).isSameAs(expected);
    }

    @Test
    public void handle() {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Function handler = (Function)Mockito.mock(Function.class);
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).handle((java.util.function.Function)Mockito.any());
        Object value = new Object();
        Object handled = new Object();
        RuntimeException exception = new RuntimeException();
        ((Supplier)Mockito.doReturn((Object)value).when((Object)supplier)).get();
        Assertions.assertThat((Object)supplier.handle((java.util.function.Function)handler).get()).isSameAs(value);
        ((Supplier)Mockito.verify((Object)supplier)).get();
        ((Function)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).apply((Object)((RuntimeException)Mockito.any()));
        ((Supplier)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)handled).when((Object)handler)).apply((Object)exception);
        Assertions.assertThat((Object)supplier.handle((java.util.function.Function)handler).get()).isSameAs(handled);
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).get();
        ((Function)Mockito.verify((Object)handler)).apply((Object)((RuntimeException)Mockito.any()));
    }

    @Test
    public void of() {
        Object expected = new Object();
        Assertions.assertThat((Object)Supplier.of((Object)expected).get()).isSameAs(expected);
        Assertions.assertThat((Object)Supplier.of(null).get()).isNull();
    }

    @Test
    public void run() {
        Runnable runner = (Runnable)Mockito.mock(Runnable.class);
        Assertions.assertThat((Object)Supplier.run((java.lang.Runnable)runner).get()).isNull();
        ((Runnable)Mockito.verify((Object)runner)).run();
        Assertions.assertThat((Object)Supplier.run(null).get()).isNull();
    }

    @Test
    public void call() throws Exception {
        Callable caller = (Callable)Mockito.mock(Callable.class);
        Function handler = (Function)Mockito.mock(Function.class);
        Assertions.assertThat((Object)Supplier.call((java.util.concurrent.Callable)caller, (java.util.function.Function)handler).get()).isNull();
        ((Callable)Mockito.verify((Object)caller)).call();
        ((Function)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).apply((Object)((Exception)Mockito.any()));
        Object result = new Object();
        ((Callable)Mockito.doReturn((Object)result).when((Object)caller)).call();
        Assertions.assertThat((Object)Supplier.call((java.util.concurrent.Callable)caller, (java.util.function.Function)handler).get()).isSameAs(result);
        ((Callable)Mockito.verify((Object)caller, (VerificationMode)Mockito.times((int)2))).call();
        ((Function)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).apply((Object)((Exception)Mockito.any()));
        Exception exception = new Exception();
        Object handled = new Object();
        ((Callable)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)caller)).call();
        ((Function)Mockito.doReturn((Object)handled).when((Object)handler)).apply((Object)exception);
        Assertions.assertThat((Object)Supplier.call((java.util.concurrent.Callable)caller, (java.util.function.Function)handler).get()).isSameAs(handled);
        ((Callable)Mockito.verify((Object)caller, (VerificationMode)Mockito.times((int)3))).call();
        ((Function)Mockito.verify((Object)handler)).apply((Object)exception);
    }
}

