/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.BiFunction;

public class BiFunctionTestCase {
    private final UUID value1 = UUID.randomUUID();
    private final UUID value2 = UUID.randomUUID();
    private final UUID result = UUID.randomUUID();

    @Test
    public void test() {
        Assertions.assertThat((Object)BiFunction.empty().apply((Object)this.value1, (Object)this.value2)).isNull();
        Assertions.assertThat((Comparable)((UUID)BiFunction.of((Object)this.result).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)this.result);
        Assertions.assertThat((Object)BiFunction.of(null).apply((Object)this.value1, (Object)this.value2)).isNull();
        Assertions.assertThat((Object)BiFunction.former().apply((Object)this.value1, (Object)this.value2)).isSameAs((Object)this.value1);
        Assertions.assertThat((Object)BiFunction.latter().apply((Object)this.value1, (Object)this.value2)).isSameAs((Object)this.value2);
    }

    @Test
    public void of() {
        BiConsumer consumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)this.result).when((Object)supplier)).get();
        BiFunction function = BiFunction.of((java.util.function.BiConsumer)consumer, (Supplier)supplier);
        UUID result = (UUID)function.apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
        ((BiConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.only())).accept((Object)this.value1, (Object)this.value2);
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.only())).get();
    }

    @Test
    public void andThen() {
        UUID interrimResult = UUID.randomUUID();
        BiFunction before = (BiFunction)Mockito.mock(BiFunction.class);
        Function after = (Function)Mockito.mock(Function.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)before)).andThen((Function)Mockito.any());
        ((BiFunction)Mockito.doReturn((Object)interrimResult).when((Object)before)).apply((Object)this.value1, (Object)this.value2);
        ((Function)Mockito.doReturn((Object)this.result).when((Object)after)).apply(interrimResult);
        Object result = before.andThen(after).apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Object)result).isSameAs((Object)this.result);
    }

    @Test
    public void compose() {
        UUID interrimResult1 = UUID.randomUUID();
        UUID interrimResult2 = UUID.randomUUID();
        BiFunction after = (BiFunction)Mockito.mock(BiFunction.class);
        Function before1 = (Function)Mockito.mock(Function.class);
        Function before2 = (Function)Mockito.mock(Function.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)after)).compose((Function)Mockito.any(), (Function)Mockito.any());
        ((Function)Mockito.doReturn((Object)interrimResult1).when((Object)before1)).apply(this.value1);
        ((Function)Mockito.doReturn((Object)interrimResult2).when((Object)before2)).apply(this.value2);
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)after)).apply((Object)interrimResult1, (Object)interrimResult2);
        UUID result = (UUID)after.compose(before1, before2).apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
    }

    @Test
    public void composeUnary() {
        UUID interrimResult1 = UUID.randomUUID();
        UUID interrimResult2 = UUID.randomUUID();
        BiFunction after = (BiFunction)Mockito.mock(BiFunction.class);
        Function before1 = (Function)Mockito.mock(Function.class);
        Function before2 = (Function)Mockito.mock(Function.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)after)).composeUnary((Function)Mockito.any(), (Function)Mockito.any());
        ((Function)Mockito.doReturn((Object)interrimResult1).when((Object)before1)).apply(this.value1);
        ((Function)Mockito.doReturn((Object)interrimResult2).when((Object)before2)).apply(this.value1);
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)after)).apply((Object)interrimResult1, (Object)interrimResult2);
        UUID result = (UUID)after.composeUnary(before1, before2).apply((Object)this.value1);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
    }

    @Test
    public void reverse() {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)function)).apply((Object)this.value1, (Object)this.value2);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)function)).reverse();
        UUID result = (UUID)function.reverse().apply((Object)this.value2, (Object)this.value1);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
    }

    @Test
    public void withDefault() {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)function)).withDefault((Predicate)Mockito.any(), (Supplier)Mockito.any(), (Predicate)Mockito.any(), (Supplier)Mockito.any());
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier1 = (Supplier)Mockito.mock(Supplier.class);
        Supplier supplier2 = (Supplier)Mockito.mock(Supplier.class);
        UUID expectedWhenDefaultValue1 = UUID.randomUUID();
        UUID expectedWhenDefaultValue2 = UUID.randomUUID();
        UUID expectedWhenDefaultValues = UUID.randomUUID();
        UUID defaultValue1 = UUID.randomUUID();
        UUID defaultValue2 = UUID.randomUUID();
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate1)).test(this.value1);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate2)).test(this.value2);
        ((Supplier)Mockito.doReturn((Object)defaultValue1).when((Object)supplier1)).get();
        ((Supplier)Mockito.doReturn((Object)defaultValue2).when((Object)supplier2)).get();
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)function)).apply((Object)this.value1, (Object)this.value2);
        ((BiFunction)Mockito.doReturn((Object)expectedWhenDefaultValues).when((Object)function)).apply((Object)defaultValue1, (Object)defaultValue2);
        ((BiFunction)Mockito.doReturn((Object)expectedWhenDefaultValue1).when((Object)function)).apply((Object)defaultValue1, (Object)this.value2);
        ((BiFunction)Mockito.doReturn((Object)expectedWhenDefaultValue2).when((Object)function)).apply((Object)this.value1, (Object)defaultValue2);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)expectedWhenDefaultValues);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)expectedWhenDefaultValue1);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)expectedWhenDefaultValue2);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)this.result);
    }

    @Test
    public void orDefault() {
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doCallRealMethod().when((Object)function)).orDefault((BiPredicate)Mockito.any(), (Supplier)Mockito.any());
        BiPredicate predicate = (BiPredicate)Mockito.mock(BiPredicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        UUID defaultValue = UUID.randomUUID();
        ((BiPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(this.value1, this.value2);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((BiFunction)Mockito.doReturn((Object)this.result).when((Object)function)).apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Comparable)((UUID)function.orDefault(predicate, supplier).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)defaultValue);
        Assertions.assertThat((Comparable)((UUID)function.orDefault(predicate, supplier).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)this.result);
    }
}

