/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiPredicate;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.UnaryOperator;

public class BiPredicateTestCase {
    private final UUID value1 = UUID.randomUUID();
    private final UUID value2 = UUID.randomUUID();
    private final Random random = new Random();

    @Test
    public void former() {
        java.util.function.Predicate predicate1 = (java.util.function.Predicate)Mockito.mock(java.util.function.Predicate.class);
        boolean expected = this.random.nextBoolean();
        ((java.util.function.Predicate)Mockito.doReturn((Object)expected).when((Object)predicate1)).test(this.value1);
        BiPredicate predicate = BiPredicate.testFormer((java.util.function.Predicate)predicate1);
        Assertions.assertThat((boolean)predicate.test((Object)this.value1, (Object)this.value2)).isEqualTo(expected);
        ((java.util.function.Predicate)Mockito.verify((Object)predicate1, (VerificationMode)Mockito.only())).test(this.value1);
    }

    @Test
    public void latter() {
        java.util.function.Predicate predicate2 = (java.util.function.Predicate)Mockito.mock(java.util.function.Predicate.class);
        boolean expected = this.random.nextBoolean();
        ((java.util.function.Predicate)Mockito.doReturn((Object)expected).when((Object)predicate2)).test(this.value2);
        BiPredicate predicate = BiPredicate.testLatter((java.util.function.Predicate)predicate2);
        Assertions.assertThat((boolean)predicate.test((Object)this.value1, (Object)this.value2)).isEqualTo(expected);
        ((java.util.function.Predicate)Mockito.verify((Object)predicate2, (VerificationMode)Mockito.only())).test(this.value2);
    }

    @Test
    public void negate() {
        BiPredicate predicate = (BiPredicate)Mockito.mock(BiPredicate.class);
        boolean expected = this.random.nextBoolean();
        ((BiPredicate)Mockito.doCallRealMethod().when((Object)predicate)).negate();
        ((BiPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test((Object)this.value1, (Object)this.value2);
        BiPredicate negative = predicate.negate();
        Assertions.assertThat((boolean)negative.test((Object)this.value1, (Object)this.value2)).isNotEqualTo(expected);
        ((BiPredicate)Mockito.verify((Object)predicate)).test((Object)this.value1, (Object)this.value2);
    }

    @Test
    public void and() {
        java.util.function.Predicate predicate1 = (java.util.function.Predicate)Mockito.mock(java.util.function.Predicate.class);
        java.util.function.Predicate predicate2 = (java.util.function.Predicate)Mockito.mock(java.util.function.Predicate.class);
        boolean expected1 = this.random.nextBoolean();
        boolean expected2 = this.random.nextBoolean();
        ((java.util.function.Predicate)Mockito.doReturn((Object)expected1).when((Object)predicate1)).test(this.value1);
        ((java.util.function.Predicate)Mockito.doReturn((Object)expected2).when((Object)predicate2)).test(this.value2);
        BiPredicate predicate = BiPredicate.and((java.util.function.Predicate)predicate1, (java.util.function.Predicate)predicate2);
        Assertions.assertThat((boolean)predicate.test((Object)this.value1, (Object)this.value2)).isEqualTo(expected1 && expected2);
        ((java.util.function.Predicate)Mockito.verify((Object)predicate1, (VerificationMode)Mockito.only())).test(this.value1);
        if (expected1) {
            ((java.util.function.Predicate)Mockito.verify((Object)predicate2, (VerificationMode)Mockito.only())).test(this.value2);
        }
    }

    @Test
    public void or() {
        java.util.function.Predicate predicate1 = (java.util.function.Predicate)Mockito.mock(java.util.function.Predicate.class);
        java.util.function.Predicate predicate2 = (java.util.function.Predicate)Mockito.mock(java.util.function.Predicate.class);
        boolean expected1 = this.random.nextBoolean();
        boolean expected2 = this.random.nextBoolean();
        ((java.util.function.Predicate)Mockito.doReturn((Object)expected1).when((Object)predicate1)).test(this.value1);
        ((java.util.function.Predicate)Mockito.doReturn((Object)expected2).when((Object)predicate2)).test(this.value2);
        BiPredicate predicate = BiPredicate.or((java.util.function.Predicate)predicate1, (java.util.function.Predicate)predicate2);
        Assertions.assertThat((boolean)predicate.test((Object)this.value1, (Object)this.value2)).isEqualTo(expected1 || expected2);
        ((java.util.function.Predicate)Mockito.verify((Object)predicate1, (VerificationMode)Mockito.only())).test(this.value1);
        if (!expected1) {
            ((java.util.function.Predicate)Mockito.verify((Object)predicate2, (VerificationMode)Mockito.only())).test(this.value2);
        }
    }

    @Test
    public void compose() {
        BiPredicate after = (BiPredicate)Mockito.mock(BiPredicate.class);
        UnaryOperator before1 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UnaryOperator before2 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((BiPredicate)Mockito.doCallRealMethod().when((Object)after)).compose((Function)ArgumentMatchers.any(), (Function)ArgumentMatchers.any());
        BiPredicate predicate = after.compose((Function)before1, (Function)before2);
        UUID interrimValue1 = UUID.randomUUID();
        UUID interrimValue2 = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        ((UnaryOperator)Mockito.doReturn((Object)interrimValue1).when((Object)before1)).apply((Object)this.value1);
        ((UnaryOperator)Mockito.doReturn((Object)interrimValue2).when((Object)before2)).apply((Object)this.value2);
        ((BiPredicate)Mockito.doReturn((Object)expected).when((Object)after)).test((Object)interrimValue1, (Object)interrimValue2);
        Assertions.assertThat((boolean)predicate.test((Object)this.value1, (Object)this.value2)).isEqualTo(expected);
    }

    @Test
    public void composeUnary() {
        BiPredicate after = (BiPredicate)Mockito.mock(BiPredicate.class);
        UnaryOperator before1 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UnaryOperator before2 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((BiPredicate)Mockito.doCallRealMethod().when((Object)after)).composeUnary((Function)ArgumentMatchers.any(), (Function)ArgumentMatchers.any());
        Predicate predicate = after.composeUnary((Function)before1, (Function)before2);
        UUID interrimValue1 = UUID.randomUUID();
        UUID interrimValue2 = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        ((UnaryOperator)Mockito.doReturn((Object)interrimValue1).when((Object)before1)).apply((Object)this.value1);
        ((UnaryOperator)Mockito.doReturn((Object)interrimValue2).when((Object)before2)).apply((Object)this.value1);
        ((BiPredicate)Mockito.doReturn((Object)expected).when((Object)after)).test((Object)interrimValue1, (Object)interrimValue2);
        Assertions.assertThat((boolean)predicate.test(this.value1)).isEqualTo(expected);
    }
}

