/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.BinaryOperator;
import org.wildfly.clustering.function.UnaryOperator;

public class BinaryOperatorTestCase {
    private final UUID value1 = UUID.randomUUID();
    private final UUID value2 = UUID.randomUUID();
    private final UUID result = UUID.randomUUID();

    @Test
    public void test() {
        Assertions.assertThat((Object)BinaryOperator.empty().apply((Object)this.value1, (Object)this.value2)).isNull();
        Assertions.assertThat((Comparable)((UUID)BinaryOperator.of((Object)this.result).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)this.result);
        Assertions.assertThat((Object)BinaryOperator.of(null).apply((Object)this.value1, (Object)this.value2)).isNull();
        Assertions.assertThat((Object)BinaryOperator.former().apply((Object)this.value1, (Object)this.value2)).isSameAs((Object)this.value1);
        Assertions.assertThat((Object)BinaryOperator.latter().apply((Object)this.value1, (Object)this.value2)).isSameAs((Object)this.value2);
    }

    @Test
    public void of() {
        BiConsumer consumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)this.result).when((Object)supplier)).get();
        BinaryOperator function = BinaryOperator.of((java.util.function.BiConsumer)consumer, (Supplier)supplier);
        UUID result = (UUID)function.apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
        ((BiConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.only())).accept((Object)this.value1, (Object)this.value2);
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.only())).get();
    }

    @Test
    public void andThen() {
        UUID interrimResult = UUID.randomUUID();
        BinaryOperator before = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        UnaryOperator after = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((BinaryOperator)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.UnaryOperator)ArgumentMatchers.any());
        ((BinaryOperator)Mockito.doReturn((Object)interrimResult).when((Object)before)).apply((Object)this.value1, (Object)this.value2);
        ((UnaryOperator)Mockito.doReturn((Object)this.result).when((Object)after)).apply((Object)interrimResult);
        Object result = before.andThen((java.util.function.UnaryOperator)after).apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Object)result).isSameAs((Object)this.result);
    }

    @Test
    public void compose() {
        UUID interrimResult1 = UUID.randomUUID();
        UUID interrimResult2 = UUID.randomUUID();
        BinaryOperator after = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        UnaryOperator before1 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UnaryOperator before2 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((BinaryOperator)Mockito.doCallRealMethod().when((Object)after)).compose((java.util.function.UnaryOperator)ArgumentMatchers.any(), (java.util.function.UnaryOperator)ArgumentMatchers.any());
        ((UnaryOperator)Mockito.doReturn((Object)interrimResult1).when((Object)before1)).apply((Object)this.value1);
        ((UnaryOperator)Mockito.doReturn((Object)interrimResult2).when((Object)before2)).apply((Object)this.value2);
        ((BinaryOperator)Mockito.doReturn((Object)this.result).when((Object)after)).apply((Object)interrimResult1, (Object)interrimResult2);
        UUID result = (UUID)after.compose((java.util.function.UnaryOperator)before1, (java.util.function.UnaryOperator)before2).apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
    }

    @Test
    public void composeUnary() {
        UUID interrimResult1 = UUID.randomUUID();
        UUID interrimResult2 = UUID.randomUUID();
        BinaryOperator after = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        UnaryOperator before1 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UnaryOperator before2 = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((BinaryOperator)Mockito.doCallRealMethod().when((Object)after)).composeUnary((java.util.function.UnaryOperator)ArgumentMatchers.any(), (java.util.function.UnaryOperator)ArgumentMatchers.any());
        ((UnaryOperator)Mockito.doReturn((Object)interrimResult1).when((Object)before1)).apply((Object)this.value1);
        ((UnaryOperator)Mockito.doReturn((Object)interrimResult2).when((Object)before2)).apply((Object)this.value1);
        ((BinaryOperator)Mockito.doReturn((Object)this.result).when((Object)after)).apply((Object)interrimResult1, (Object)interrimResult2);
        UUID result = (UUID)after.composeUnary((java.util.function.UnaryOperator)before1, (java.util.function.UnaryOperator)before2).apply((Object)this.value1);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
    }

    @Test
    public void reverse() {
        BinaryOperator function = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        ((BinaryOperator)Mockito.doReturn((Object)this.result).when((Object)function)).apply((Object)this.value1, (Object)this.value2);
        ((BinaryOperator)Mockito.doCallRealMethod().when((Object)function)).reverse();
        UUID result = (UUID)function.reverse().apply((Object)this.value2, (Object)this.value1);
        Assertions.assertThat((Comparable)result).isSameAs((Object)this.result);
    }

    @Test
    public void withDefault() {
        BinaryOperator function = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        ((BinaryOperator)Mockito.doCallRealMethod().when((Object)function)).withDefault((Predicate)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any());
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier1 = (Supplier)Mockito.mock(Supplier.class);
        Supplier supplier2 = (Supplier)Mockito.mock(Supplier.class);
        UUID expectedWhenDefaultValue1 = UUID.randomUUID();
        UUID expectedWhenDefaultValue2 = UUID.randomUUID();
        UUID expectedWhenDefaultValues = UUID.randomUUID();
        UUID defaultValue1 = UUID.randomUUID();
        UUID defaultValue2 = UUID.randomUUID();
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate1)).test(this.value1);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate2)).test(this.value2);
        ((Supplier)Mockito.doReturn((Object)defaultValue1).when((Object)supplier1)).get();
        ((Supplier)Mockito.doReturn((Object)defaultValue2).when((Object)supplier2)).get();
        ((BinaryOperator)Mockito.doReturn((Object)this.result).when((Object)function)).apply((Object)this.value1, (Object)this.value2);
        ((BinaryOperator)Mockito.doReturn((Object)expectedWhenDefaultValues).when((Object)function)).apply((Object)defaultValue1, (Object)defaultValue2);
        ((BinaryOperator)Mockito.doReturn((Object)expectedWhenDefaultValue1).when((Object)function)).apply((Object)defaultValue1, (Object)this.value2);
        ((BinaryOperator)Mockito.doReturn((Object)expectedWhenDefaultValue2).when((Object)function)).apply((Object)this.value1, (Object)defaultValue2);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)expectedWhenDefaultValues);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)expectedWhenDefaultValue1);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)expectedWhenDefaultValue2);
        Assertions.assertThat((Comparable)((UUID)function.withDefault(predicate1, supplier1, predicate2, supplier2).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)this.result);
    }

    @Test
    public void orDefault() {
        BinaryOperator function = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        ((BinaryOperator)Mockito.doCallRealMethod().when((Object)function)).orDefault((BiPredicate)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any());
        BiPredicate predicate = (BiPredicate)Mockito.mock(BiPredicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        UUID defaultValue = UUID.randomUUID();
        ((BiPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(this.value1, this.value2);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((BinaryOperator)Mockito.doReturn((Object)this.result).when((Object)function)).apply((Object)this.value1, (Object)this.value2);
        Assertions.assertThat((Comparable)((UUID)function.orDefault(predicate, supplier).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)defaultValue);
        Assertions.assertThat((Comparable)((UUID)function.orDefault(predicate, supplier).apply((Object)this.value1, (Object)this.value2))).isSameAs((Object)this.result);
    }
}

