/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.Predicate;

public class BooleanSupplierTestCase {
    private final Random random = new Random();

    @Test
    public void of() {
        boolean value = this.random.nextBoolean();
        Assertions.assertThat((boolean)BooleanSupplier.of((boolean)value).getAsBoolean()).isEqualTo(value);
        Assertions.assertThat((boolean)BooleanSupplier.TRUE.getAsBoolean()).isTrue();
        Assertions.assertThat((boolean)BooleanSupplier.FALSE.getAsBoolean()).isFalse();
        Assertions.assertThat((boolean)BooleanSupplier.TRUE.negate().getAsBoolean()).isFalse();
        Assertions.assertThat((boolean)BooleanSupplier.FALSE.negate().getAsBoolean()).isTrue();
    }

    @Test
    public void handle() {
        boolean value = this.random.nextBoolean();
        boolean handled = this.random.nextBoolean();
        BooleanSupplier supplier = (BooleanSupplier)Mockito.mock(BooleanSupplier.class);
        ((BooleanSupplier)Mockito.doCallRealMethod().when((Object)supplier)).handle((java.util.function.Predicate)Mockito.any());
        ((BooleanSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsBoolean();
        Predicate handler = (Predicate)Mockito.mock(Predicate.class);
        RuntimeException exception = new RuntimeException();
        Assertions.assertThat((boolean)supplier.handle((java.util.function.Predicate)handler).getAsBoolean()).isEqualTo(value);
        ((BooleanSupplier)Mockito.verify((Object)supplier)).getAsBoolean();
        ((Predicate)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).test((Object)((RuntimeException)Mockito.any()));
        ((BooleanSupplier)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)supplier)).getAsBoolean();
        ((Predicate)Mockito.doReturn((Object)handled).when((Object)handler)).test((Object)exception);
        Assertions.assertThat((boolean)supplier.handle((java.util.function.Predicate)handler).getAsBoolean()).isEqualTo(handled);
        ((BooleanSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).getAsBoolean();
        ((Predicate)Mockito.verify((Object)handler)).test((Object)((RuntimeException)Mockito.any()));
    }
}

