/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public class ConsumerTestCase {
    @Test
    public void thenReturn() {
        Object value = new Object();
        Object expected = new Object();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).thenReturn((java.util.function.Supplier)Mockito.any());
        Object result = consumer.thenReturn((java.util.function.Supplier)supplier).apply(value);
        Assertions.assertThat((Object)result).isSameAs(expected);
        ((Consumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void when() {
        UUID allowed = UUID.randomUUID();
        UUID disallowed = UUID.randomUUID();
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doReturn((Object)true).when((Object)predicate)).test((Object)allowed);
        ((Predicate)Mockito.doReturn((Object)false).when((Object)predicate)).test((Object)disallowed);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).when((java.util.function.Predicate)Mockito.any());
        Consumer conditional = consumer.when((java.util.function.Predicate)predicate);
        conditional.accept((Object)disallowed);
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept((Object)disallowed);
        conditional.accept((Object)allowed);
        ((Consumer)Mockito.verify((Object)consumer)).accept((Object)allowed);
    }

    @Test
    public void withDefault() {
        UUID allowed = UUID.randomUUID();
        UUID disallowed = UUID.randomUUID();
        UUID defaultValue = UUID.randomUUID();
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doReturn((Object)true).when((Object)predicate)).test((Object)allowed);
        ((Predicate)Mockito.doReturn((Object)false).when((Object)predicate)).test((Object)disallowed);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier defaultProvider = (Supplier)Mockito.mock(Supplier.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).withDefault((java.util.function.Predicate)Mockito.any(), (java.util.function.Supplier)Mockito.any());
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)defaultProvider)).get();
        Consumer conditional = consumer.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)defaultProvider);
        conditional.accept((Object)allowed);
        ((Consumer)Mockito.verify((Object)consumer)).accept((Object)allowed);
        Mockito.verifyNoInteractions((Object[])new Object[]{defaultProvider});
        conditional.accept((Object)disallowed);
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept((Object)disallowed);
        ((Consumer)Mockito.verify((Object)consumer)).accept((Object)defaultValue);
    }

    @Test
    public void throwing() {
        IOException cause = new IOException();
        Consumer consumer = Consumer.throwing(UncheckedIOException::new);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> consumer.accept((Object)cause)).isExactlyInstanceOf(UncheckedIOException.class)).cause().isSameAs((Object)cause);
    }

    @Test
    public void compose() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((java.util.function.Function)ArgumentMatchers.any());
        Function mapper = (Function)Mockito.mock(Function.class);
        Object value = new Object();
        Object result = new Object();
        ((Function)Mockito.doReturn((Object)result).when((Object)mapper)).apply(value);
        consumer.compose((java.util.function.Function)mapper).accept(value);
        ((Consumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeBinary() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((java.util.function.BiFunction)ArgumentMatchers.any());
        BiFunction mapper = (BiFunction)Mockito.mock(BiFunction.class);
        Object key = new Object();
        Object value = new Object();
        Object result = new Object();
        ((BiFunction)Mockito.doReturn((Object)result).when((Object)mapper)).apply(key, value);
        consumer.compose((java.util.function.BiFunction)mapper).accept(key, value);
        ((Consumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void empty() {
        Consumer consumer = Consumer.empty();
        consumer.accept(new Object());
        consumer.accept(null);
    }

    @Test
    public void handle() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        BiConsumer handler = (BiConsumer)Mockito.mock(BiConsumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).handle((java.util.function.BiConsumer)Mockito.any());
        Object goodValue = new Object();
        Object badValue = new Object();
        RuntimeException exception = new RuntimeException();
        ((Consumer)Mockito.doNothing().when((Object)consumer)).accept(goodValue);
        ((Consumer)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)consumer)).accept(badValue);
        consumer.handle((java.util.function.BiConsumer)handler).accept(goodValue);
        ((Consumer)Mockito.verify((Object)consumer)).accept(goodValue);
        ((BiConsumer)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).accept(Mockito.any(), (Object)((RuntimeException)Mockito.any()));
        consumer.handle((java.util.function.BiConsumer)handler).accept(badValue);
        ((BiConsumer)Mockito.verify((Object)handler)).accept(badValue, (Object)exception);
    }

    @Test
    public void close() throws Exception {
        AutoCloseable resource = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        Consumer consumer = Consumer.close((java.util.function.Consumer)Consumer.debug());
        consumer.accept((Object)resource);
        ((AutoCloseable)Mockito.verify((Object)resource)).close();
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{new Exception()}).when((Object)resource)).close();
        consumer.accept((Object)resource);
        IllegalStateException exception = new IllegalStateException();
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)resource)).close();
        Assertions.assertThatThrownBy(resource::close).isSameAs((Object)exception);
    }

    @Test
    public void ofRunnable() {
        Object value = new Object();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Consumer consumer = Consumer.run((Runnable)runnable);
        consumer.accept(value);
        ((Runnable)Mockito.verify((Object)runnable)).run();
    }

    @Test
    public void andThen() {
        Object value = new Object();
        Consumer before = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.Consumer)Mockito.any());
        Consumer after = (Consumer)Mockito.mock(Consumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{before, after});
        before.andThen((java.util.function.Consumer)after).accept(value);
        ((Consumer)order.verify((Object)before)).accept(value);
        ((Consumer)order.verify((Object)after)).accept(value);
    }

    @Test
    public void acceptAll() {
        Object value = new Object();
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        Consumer consumer3 = (Consumer)Mockito.mock(Consumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2, consumer3});
        Consumer consumer = Consumer.acceptAll(List.of(consumer1, consumer2, consumer3));
        consumer.accept(value);
        ((Consumer)order.verify((Object)consumer1)).accept(value);
        ((Consumer)order.verify((Object)consumer2)).accept(value);
        ((Consumer)order.verify((Object)consumer3)).accept(value);
    }
}

