/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.Random;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.DoubleConsumer;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.DoubleSupplier;
import org.wildfly.clustering.function.Supplier;

public class DoubleConsumerTestCase {
    private final Random random = new Random();

    @Test
    public void thenReturn() {
        Object value = new Object();
        Object expected = new Object();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).thenReturn((java.util.function.Supplier)Mockito.any());
        Object result = consumer.thenReturn((java.util.function.Supplier)supplier).apply(value);
        Assertions.assertThat((Object)result).isSameAs(expected);
        ((Consumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void when() {
        double allowed = this.random.nextDouble();
        double disallowed = this.random.nextDouble();
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(allowed);
        ((DoublePredicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(disallowed);
        DoubleConsumer consumer = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        ((DoubleConsumer)Mockito.doCallRealMethod().when((Object)consumer)).when((java.util.function.DoublePredicate)Mockito.any());
        DoubleConsumer conditional = consumer.when((java.util.function.DoublePredicate)predicate);
        conditional.accept(disallowed);
        ((DoubleConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(disallowed);
        conditional.accept(allowed);
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(allowed);
    }

    @Test
    public void withDefault() {
        double allowed = this.random.nextDouble();
        double disallowed = this.random.nextDouble();
        double defaultValue = this.random.nextDouble();
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(allowed);
        ((DoublePredicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(disallowed);
        DoubleConsumer consumer = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        DoubleSupplier defaultProvider = (DoubleSupplier)Mockito.mock(DoubleSupplier.class);
        ((DoubleConsumer)Mockito.doCallRealMethod().when((Object)consumer)).withDefault((java.util.function.DoublePredicate)Mockito.any(), (java.util.function.DoubleSupplier)Mockito.any());
        ((DoubleSupplier)Mockito.doReturn((Object)defaultValue).when((Object)defaultProvider)).getAsDouble();
        DoubleConsumer conditional = consumer.withDefault((java.util.function.DoublePredicate)predicate, (java.util.function.DoubleSupplier)defaultProvider);
        conditional.accept(allowed);
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(allowed);
        Mockito.verifyNoInteractions((Object[])new Object[]{defaultProvider});
        conditional.accept(disallowed);
        ((DoubleConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(disallowed);
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(defaultValue);
    }

    @Test
    public void compose() {
        DoubleConsumer consumer = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        ((DoubleConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((ToDoubleFunction)ArgumentMatchers.any());
        ToDoubleFunction composer = (ToDoubleFunction)Mockito.mock(ToDoubleFunction.class);
        Object value = new Object();
        double result = this.random.nextDouble();
        ((ToDoubleFunction)Mockito.doReturn((Object)result).when((Object)composer)).applyAsDouble(value);
        consumer.compose(composer).accept(value);
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeAsDouble() {
        DoubleConsumer consumer = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        ((DoubleConsumer)Mockito.doCallRealMethod().when((Object)consumer)).composeAsDouble((DoubleUnaryOperator)ArgumentMatchers.any());
        DoubleUnaryOperator composer = (DoubleUnaryOperator)Mockito.mock(DoubleUnaryOperator.class);
        double value = this.random.nextDouble();
        double result = this.random.nextDouble();
        ((DoubleUnaryOperator)Mockito.doReturn((Object)result).when((Object)composer)).applyAsDouble(value);
        consumer.composeAsDouble(composer).accept(value);
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeBinary() {
        DoubleConsumer consumer = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        ((DoubleConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((ToDoubleBiFunction)ArgumentMatchers.any());
        ToDoubleBiFunction composer = (ToDoubleBiFunction)Mockito.mock(ToDoubleBiFunction.class);
        Object key = new Object();
        Object value = new Object();
        double result = this.random.nextDouble();
        ((ToDoubleBiFunction)Mockito.doReturn((Object)result).when((Object)composer)).applyAsDouble(key, value);
        consumer.compose(composer).accept(key, value);
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void empty() {
        DoubleConsumer consumer = DoubleConsumer.EMPTY;
        consumer.accept(this.random.nextDouble());
    }

    @Test
    public void andThen() {
        double value = this.random.nextDouble();
        DoubleConsumer before = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        ((DoubleConsumer)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.DoubleConsumer)Mockito.any());
        DoubleConsumer after = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{before, after});
        before.andThen((java.util.function.DoubleConsumer)after).accept(value);
        ((DoubleConsumer)order.verify((Object)before)).accept(value);
        ((DoubleConsumer)order.verify((Object)after)).accept(value);
    }

    @Test
    public void acceptAll() {
        double value = this.random.nextDouble();
        DoubleConsumer consumer1 = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        DoubleConsumer consumer2 = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        DoubleConsumer consumer3 = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2, consumer3});
        DoubleConsumer consumer = DoubleConsumer.acceptAll(List.of(consumer1, consumer2, consumer3));
        consumer.accept(value);
        ((DoubleConsumer)order.verify((Object)consumer1)).accept(value);
        ((DoubleConsumer)order.verify((Object)consumer2)).accept(value);
        ((DoubleConsumer)order.verify((Object)consumer3)).accept(value);
    }
}

