/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.ToDoubleFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.DoublePredicate;

public class DoublePredicateTestCase {
    private final Random random = new Random();

    @Test
    public void test() {
        double positive = this.random.nextDouble() + 1.0;
        double negative = this.random.nextDouble() - 1.0;
        Assertions.assertThat((boolean)DoublePredicate.ALWAYS.test(negative)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.ALWAYS.test(0.0)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.ALWAYS.test(positive)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.NEVER.test(negative)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.NEVER.test(0.0)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.NEVER.test(positive)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.of((boolean)true).test(negative)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.of((boolean)true).test(0.0)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.of((boolean)true).test(positive)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.of((boolean)false).test(negative)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.of((boolean)false).test(0.0)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.of((boolean)false).test(positive)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.NEGATIVE.test(negative)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.NEGATIVE.test(0.0)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.NEGATIVE.test(positive)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.ZERO.test(negative)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.ZERO.test(0.0)).isTrue();
        Assertions.assertThat((boolean)DoublePredicate.ZERO.test(positive)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.POSITIVE.test(negative)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.POSITIVE.test(0.0)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.POSITIVE.test(positive)).isTrue();
    }

    @Test
    public void equalTo() {
        double value = this.random.nextDouble();
        double different = this.random.nextDouble();
        DoublePredicate predicate = DoublePredicate.equalTo((double)value);
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(different)).isFalse();
    }

    @Test
    public void lessThan() {
        double value = this.random.nextDouble();
        DoublePredicate predicate = DoublePredicate.lessThan((double)value);
        Assertions.assertThat((boolean)predicate.test(value - 1.0)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value + 1.0)).isFalse();
    }

    @Test
    public void greaterThan() {
        double value = this.random.nextDouble();
        DoublePredicate predicate = DoublePredicate.greaterThan((double)value);
        Assertions.assertThat((boolean)predicate.test(value - 1.0)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value + 1.0)).isTrue();
    }

    @Test
    public void negate() {
        double value = this.random.nextDouble();
        Assertions.assertThat((boolean)DoublePredicate.ALWAYS.negate().test(value)).isFalse();
        Assertions.assertThat((boolean)DoublePredicate.NEVER.negate().test(value)).isTrue();
    }

    @Test
    public void compose() {
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doCallRealMethod().when((Object)predicate)).compose((ToDoubleFunction)Mockito.any());
        UUID value = UUID.randomUUID();
        double mapped = this.random.nextDouble();
        boolean expected = this.random.nextBoolean();
        ToDoubleFunction function = (ToDoubleFunction)Mockito.mock(ToDoubleFunction.class);
        ((ToDoubleFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsDouble(value);
        ((DoublePredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.compose(function).test((Object)value)).isEqualTo(expected);
    }

    @Test
    public void composeDouble() {
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeDouble((DoubleUnaryOperator)Mockito.any());
        double value = this.random.nextDouble();
        double mapped = this.random.nextDouble();
        boolean expected = this.random.nextBoolean();
        DoubleUnaryOperator function = (DoubleUnaryOperator)Mockito.mock(DoubleUnaryOperator.class);
        ((DoubleUnaryOperator)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsDouble(value);
        ((DoublePredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeDouble(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeInt() {
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeInt((IntToDoubleFunction)Mockito.any());
        int value = this.random.nextInt();
        double mapped = this.random.nextDouble();
        boolean expected = this.random.nextBoolean();
        IntToDoubleFunction function = (IntToDoubleFunction)Mockito.mock(IntToDoubleFunction.class);
        ((IntToDoubleFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsDouble(value);
        ((DoublePredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeInt(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeLong() {
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeLong((LongToDoubleFunction)Mockito.any());
        long value = this.random.nextLong();
        double mapped = this.random.nextDouble();
        boolean expected = this.random.nextBoolean();
        LongToDoubleFunction function = (LongToDoubleFunction)Mockito.mock(LongToDoubleFunction.class);
        ((LongToDoubleFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsDouble(value);
        ((DoublePredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeLong(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void xor() {
        DoublePredicate predicate1 = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        DoublePredicate predicate2 = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        ((DoublePredicate)Mockito.doCallRealMethod().when((Object)predicate1)).xor((java.util.function.DoublePredicate)Mockito.any());
        DoublePredicate predicate = predicate1.xor((java.util.function.DoublePredicate)predicate2);
        double value = this.random.nextDouble();
        ((DoublePredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate1)).test(value);
        ((DoublePredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate2)).test(value);
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
    }
}

