/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.DoubleSupplier;

public class DoubleSupplierTestCase {
    private final Random random = new Random();

    @Test
    public void apply() {
        double value = this.random.nextDouble();
        double expectedDouble = this.random.nextDouble();
        int expectedInt = this.random.nextInt();
        long expectedLong = this.random.nextLong();
        boolean expectedBoolean = this.random.nextBoolean();
        Object expected = new Object();
        DoubleSupplier supplier = (DoubleSupplier)Mockito.mock(DoubleSupplier.class);
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenAccept((DoubleConsumer)Mockito.any());
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApply((DoubleFunction)Mockito.any());
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsDouble((DoubleUnaryOperator)Mockito.any());
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsInt((DoubleToIntFunction)Mockito.any());
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsLong((DoubleToLongFunction)Mockito.any());
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenTest((java.util.function.DoublePredicate)Mockito.any());
        ((DoubleSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsDouble();
        DoubleFunction function = (DoubleFunction)Mockito.mock(DoubleFunction.class);
        DoubleUnaryOperator toDoubleFunction = (DoubleUnaryOperator)Mockito.mock(DoubleUnaryOperator.class);
        DoubleToIntFunction toIntFunction = (DoubleToIntFunction)Mockito.mock(DoubleToIntFunction.class);
        DoubleToLongFunction toLongFunction = (DoubleToLongFunction)Mockito.mock(DoubleToLongFunction.class);
        DoublePredicate predicate = (DoublePredicate)Mockito.mock(DoublePredicate.class);
        DoubleConsumer consumer = (DoubleConsumer)Mockito.mock(DoubleConsumer.class);
        ((DoubleFunction)Mockito.doReturn((Object)expected).when((Object)function)).apply(value);
        ((DoubleUnaryOperator)Mockito.doReturn((Object)expectedDouble).when((Object)toDoubleFunction)).applyAsDouble(value);
        ((DoubleToIntFunction)Mockito.doReturn((Object)expectedInt).when((Object)toIntFunction)).applyAsInt(value);
        ((DoubleToLongFunction)Mockito.doReturn((Object)expectedLong).when((Object)toLongFunction)).applyAsLong(value);
        ((DoublePredicate)Mockito.doReturn((Object)expectedBoolean).when((Object)predicate)).test(value);
        Assertions.assertThat((Object)supplier.thenApply(function).get()).isSameAs(expected);
        Assertions.assertThat((double)supplier.thenApplyAsDouble(toDoubleFunction).getAsDouble()).isEqualTo(expectedDouble);
        Assertions.assertThat((int)supplier.thenApplyAsInt(toIntFunction).getAsInt()).isEqualTo(expectedInt);
        Assertions.assertThat((long)supplier.thenApplyAsLong(toLongFunction).getAsLong()).isEqualTo(expectedLong);
        Assertions.assertThat((boolean)supplier.thenTest((java.util.function.DoublePredicate)predicate).getAsBoolean()).isEqualTo(expectedBoolean);
        supplier.thenAccept(consumer).run();
        ((DoubleConsumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void handle() {
        double value = this.random.nextDouble();
        DoubleSupplier supplier = (DoubleSupplier)Mockito.mock(DoubleSupplier.class);
        ((DoubleSupplier)Mockito.doCallRealMethod().when((Object)supplier)).handle((ToDoubleFunction)Mockito.any());
        ((DoubleSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsDouble();
        ToDoubleFunction handler = (ToDoubleFunction)Mockito.mock(ToDoubleFunction.class);
        double handled = this.random.nextDouble();
        RuntimeException exception = new RuntimeException();
        Assertions.assertThat((double)supplier.handle(handler).getAsDouble()).isEqualTo(value);
        ((DoubleSupplier)Mockito.verify((Object)supplier)).getAsDouble();
        ((ToDoubleFunction)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).applyAsDouble((RuntimeException)Mockito.any());
        ((DoubleSupplier)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)supplier)).getAsDouble();
        ((ToDoubleFunction)Mockito.doReturn((Object)handled).when((Object)handler)).applyAsDouble(exception);
        Assertions.assertThat((double)supplier.handle(handler).getAsDouble()).isEqualTo(handled);
        ((DoubleSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).getAsDouble();
        ((ToDoubleFunction)Mockito.verify((Object)handler)).applyAsDouble((RuntimeException)Mockito.any());
    }

    @Test
    public void of() {
        long expected = this.random.nextLong();
        Assertions.assertThat((double)DoubleSupplier.of((double)expected).getAsDouble()).isEqualTo((double)expected);
        Assertions.assertThat((double)DoubleSupplier.ZERO.getAsDouble()).isEqualTo(0.0);
    }
}

