/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.function.UnaryOperator;

public class FunctionTestCase {
    @Test
    public void compose() {
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).compose((java.util.function.Function)ArgumentMatchers.any());
        Function mapper = (Function)Mockito.mock(Function.class);
        UUID value = UUID.randomUUID();
        UUID mapped = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        ((Function)Mockito.doReturn((Object)mapped).when((Object)mapper)).apply((Object)value);
        ((Function)Mockito.doReturn((Object)expected).when((Object)function)).apply((Object)mapped);
        Assertions.assertThat((Comparable)((UUID)function.compose((java.util.function.Function)mapper).apply((Object)value))).isSameAs((Object)expected);
        ((Function)Mockito.verify((Object)function)).apply((Object)mapped);
    }

    @Test
    public void composeBinary() {
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).compose((BiFunction)ArgumentMatchers.any());
        BiFunction mapper = (BiFunction)Mockito.mock(BiFunction.class);
        UUID value1 = UUID.randomUUID();
        UUID value2 = UUID.randomUUID();
        UUID mapped = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        ((BiFunction)Mockito.doReturn((Object)mapped).when((Object)mapper)).apply((Object)value1, (Object)value2);
        ((Function)Mockito.doReturn((Object)expected).when((Object)function)).apply((Object)mapped);
        Assertions.assertThat((Comparable)((UUID)function.compose(mapper).apply((Object)value1, (Object)value2))).isSameAs((Object)expected);
        ((Function)Mockito.verify((Object)function)).apply((Object)mapped);
    }

    @Test
    public void empty() {
        Assertions.assertThat((Object)Function.empty().apply((Object)UUID.randomUUID())).isNull();
    }

    @Test
    public void of() {
        UUID parameter = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        Assertions.assertThat((Comparable)((UUID)Function.of((Object)expected).apply((Object)parameter))).isSameAs((Object)expected);
        Assertions.assertThat((Object)Function.of(null).apply((Object)parameter)).isNull();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        Assertions.assertThat((Comparable)((UUID)Function.of((java.util.function.Consumer)consumer, (java.util.function.Supplier)supplier).apply((Object)parameter))).isSameAs((Object)expected);
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.only())).accept((Object)parameter);
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.only())).get();
    }

    @Test
    public void withDefault() {
        UUID result = UUID.randomUUID();
        UUID value = UUID.randomUUID();
        UUID defaultValue = UUID.randomUUID();
        UUID defaultResult = UUID.randomUUID();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).withDefault((java.util.function.Predicate)Mockito.any(), (java.util.function.Supplier)Mockito.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test((Object)value);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply((Object)value);
        ((Function)Mockito.doReturn((Object)defaultResult).when((Object)function)).apply((Object)defaultValue);
        Assertions.assertThat((Comparable)((UUID)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)defaultResult);
        Assertions.assertThat((Comparable)((UUID)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)result);
    }

    @Test
    public void orDefault() {
        UUID result = UUID.randomUUID();
        UUID value = UUID.randomUUID();
        UUID defaultResult = UUID.randomUUID();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).orDefault((java.util.function.Predicate)Mockito.any(), (java.util.function.Supplier)Mockito.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test((Object)value);
        ((Supplier)Mockito.doReturn((Object)defaultResult).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply((Object)value);
        Assertions.assertThat((Comparable)((UUID)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)defaultResult);
        Assertions.assertThat((Comparable)((UUID)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)result);
    }

    @Test
    public void handle() {
        Function function = (Function)Mockito.mock(Function.class);
        BiFunction handler = (BiFunction)Mockito.mock(BiFunction.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).handle((java.util.function.BiFunction)Mockito.any());
        UUID goodValue = UUID.randomUUID();
        UUID badValue = UUID.randomUUID();
        UUID result = UUID.randomUUID();
        UUID handled = UUID.randomUUID();
        RuntimeException exception = new RuntimeException();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply((Object)goodValue);
        ((Function)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)function)).apply((Object)badValue);
        ((BiFunction)Mockito.doReturn((Object)handled).when((Object)handler)).apply((Object)badValue, (Object)exception);
        Assertions.assertThat((Comparable)((UUID)function.handle((java.util.function.BiFunction)handler).apply((Object)goodValue))).isSameAs((Object)result);
        Assertions.assertThat((Comparable)((UUID)function.handle((java.util.function.BiFunction)handler).apply((Object)badValue))).isSameAs((Object)handled);
        ((Function)Mockito.verify((Object)function)).apply((Object)goodValue);
        ((Function)Mockito.verify((Object)function)).apply((Object)badValue);
        ((BiFunction)Mockito.verify((Object)handler)).apply((Object)badValue, (Object)exception);
    }

    @Test
    public void entry() {
        UnaryOperator keyFunction = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UnaryOperator valueFunction = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UUID sourceKey = UUID.randomUUID();
        UUID resultKey = UUID.randomUUID();
        UUID sourceValue = UUID.randomUUID();
        UUID resultValue = UUID.randomUUID();
        ((UnaryOperator)Mockito.doReturn((Object)resultKey).when((Object)keyFunction)).apply((Object)sourceKey);
        ((UnaryOperator)Mockito.doReturn((Object)resultValue).when((Object)valueFunction)).apply((Object)sourceValue);
        Function function = Function.entry((Function)keyFunction, (Function)valueFunction);
        Map.Entry result = (Map.Entry)function.apply(Map.entry(sourceKey, sourceValue));
        Assertions.assertThat((Comparable)((UUID)result.getKey())).isSameAs((Object)resultKey);
        Assertions.assertThat((Comparable)((UUID)result.getValue())).isSameAs((Object)resultValue);
    }

    @Test
    public void optional() {
        Function function = (Function)Mockito.mock(Function.class);
        UUID parameter = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        ((Function)Mockito.doCallRealMethod().when((Object)function)).optional();
        ((Function)Mockito.doReturn((Object)expected).when((Object)function)).apply((Object)parameter);
        Function optional = function.optional();
        Assertions.assertThat((Optional)((Optional)optional.apply(Optional.empty()))).isEmpty();
        ((Function)Mockito.verify((Object)function)).optional();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{function});
        Assertions.assertThat((Optional)((Optional)optional.apply(Optional.of(parameter)))).get().isEqualTo((Object)expected);
        ((Function)Mockito.verify((Object)function)).apply((Object)parameter);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{function});
    }
}

