/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.Random;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.IntConsumer;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.IntSupplier;
import org.wildfly.clustering.function.Supplier;

public class IntConsumerTestCase {
    private final Random random = new Random();

    @Test
    public void thenReturn() {
        Object value = new Object();
        Object expected = new Object();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).thenReturn((java.util.function.Supplier)Mockito.any());
        Object result = consumer.thenReturn((java.util.function.Supplier)supplier).apply(value);
        Assertions.assertThat((Object)result).isSameAs(expected);
        ((Consumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void when() {
        int allowed = this.random.nextInt();
        int disallowed = this.random.nextInt();
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(allowed);
        ((IntPredicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(disallowed);
        IntConsumer consumer = (IntConsumer)Mockito.mock(IntConsumer.class);
        ((IntConsumer)Mockito.doCallRealMethod().when((Object)consumer)).when((java.util.function.IntPredicate)Mockito.any());
        IntConsumer conditional = consumer.when((java.util.function.IntPredicate)predicate);
        conditional.accept(disallowed);
        ((IntConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(disallowed);
        conditional.accept(allowed);
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(allowed);
    }

    @Test
    public void withDefault() {
        int allowed = this.random.nextInt();
        int disallowed = this.random.nextInt();
        int defaultValue = this.random.nextInt();
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(allowed);
        ((IntPredicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(disallowed);
        IntConsumer consumer = (IntConsumer)Mockito.mock(IntConsumer.class);
        IntSupplier defaultProvider = (IntSupplier)Mockito.mock(IntSupplier.class);
        ((IntConsumer)Mockito.doCallRealMethod().when((Object)consumer)).withDefault((java.util.function.IntPredicate)Mockito.any(), (java.util.function.IntSupplier)Mockito.any());
        ((IntSupplier)Mockito.doReturn((Object)defaultValue).when((Object)defaultProvider)).getAsInt();
        IntConsumer conditional = consumer.withDefault((java.util.function.IntPredicate)predicate, (java.util.function.IntSupplier)defaultProvider);
        conditional.accept(allowed);
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(allowed);
        Mockito.verifyNoInteractions((Object[])new Object[]{defaultProvider});
        conditional.accept(disallowed);
        ((IntConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(disallowed);
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(defaultValue);
    }

    @Test
    public void compose() {
        IntConsumer consumer = (IntConsumer)Mockito.mock(IntConsumer.class);
        ((IntConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((ToIntFunction)ArgumentMatchers.any());
        ToIntFunction composer = (ToIntFunction)Mockito.mock(ToIntFunction.class);
        Object value = new Object();
        int result = this.random.nextInt();
        ((ToIntFunction)Mockito.doReturn((Object)result).when((Object)composer)).applyAsInt(value);
        consumer.compose(composer).accept(value);
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeAsInt() {
        IntConsumer consumer = (IntConsumer)Mockito.mock(IntConsumer.class);
        ((IntConsumer)Mockito.doCallRealMethod().when((Object)consumer)).composeAsInt((IntUnaryOperator)ArgumentMatchers.any());
        IntUnaryOperator composer = (IntUnaryOperator)Mockito.mock(IntUnaryOperator.class);
        int value = this.random.nextInt();
        int result = this.random.nextInt();
        ((IntUnaryOperator)Mockito.doReturn((Object)result).when((Object)composer)).applyAsInt(value);
        consumer.composeAsInt(composer).accept(value);
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeBinary() {
        IntConsumer consumer = (IntConsumer)Mockito.mock(IntConsumer.class);
        ((IntConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((ToIntBiFunction)ArgumentMatchers.any());
        ToIntBiFunction composer = (ToIntBiFunction)Mockito.mock(ToIntBiFunction.class);
        Object key = new Object();
        Object value = new Object();
        int result = this.random.nextInt();
        ((ToIntBiFunction)Mockito.doReturn((Object)result).when((Object)composer)).applyAsInt(key, value);
        consumer.compose(composer).accept(key, value);
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void empty() {
        IntConsumer consumer = IntConsumer.EMPTY;
        consumer.accept(this.random.nextInt());
    }

    @Test
    public void andThen() {
        int value = this.random.nextInt();
        IntConsumer before = (IntConsumer)Mockito.mock(IntConsumer.class);
        ((IntConsumer)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.IntConsumer)Mockito.any());
        IntConsumer after = (IntConsumer)Mockito.mock(IntConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{before, after});
        before.andThen((java.util.function.IntConsumer)after).accept(value);
        ((IntConsumer)order.verify((Object)before)).accept(value);
        ((IntConsumer)order.verify((Object)after)).accept(value);
    }

    @Test
    public void acceptAll() {
        int value = this.random.nextInt();
        IntConsumer consumer1 = (IntConsumer)Mockito.mock(IntConsumer.class);
        IntConsumer consumer2 = (IntConsumer)Mockito.mock(IntConsumer.class);
        IntConsumer consumer3 = (IntConsumer)Mockito.mock(IntConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2, consumer3});
        IntConsumer consumer = IntConsumer.acceptAll(List.of(consumer1, consumer2, consumer3));
        consumer.accept(value);
        ((IntConsumer)order.verify((Object)consumer1)).accept(value);
        ((IntConsumer)order.verify((Object)consumer2)).accept(value);
        ((IntConsumer)order.verify((Object)consumer3)).accept(value);
    }
}

