/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongToIntFunction;
import java.util.function.ToIntFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.IntPredicate;

public class IntPredicateTestCase {
    private final Random random = new Random();

    @Test
    public void test() {
        int positive = this.random.nextInt(1, Integer.MAX_VALUE);
        int negative = this.random.nextInt(Integer.MIN_VALUE, 0);
        Assertions.assertThat((boolean)IntPredicate.ALWAYS.test(negative)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.ALWAYS.test(0)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.ALWAYS.test(positive)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.NEVER.test(negative)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.NEVER.test(0)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.NEVER.test(positive)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.of((boolean)true).test(negative)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.of((boolean)true).test(0)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.of((boolean)true).test(positive)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.of((boolean)false).test(negative)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.of((boolean)false).test(0)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.of((boolean)false).test(positive)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.NEGATIVE.test(negative)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.NEGATIVE.test(0)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.NEGATIVE.test(positive)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.ZERO.test(negative)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.ZERO.test(0)).isTrue();
        Assertions.assertThat((boolean)IntPredicate.ZERO.test(positive)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.POSITIVE.test(negative)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.POSITIVE.test(0)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.POSITIVE.test(positive)).isTrue();
    }

    @Test
    public void equalTo() {
        int value = this.random.nextInt();
        int different = this.random.nextInt();
        IntPredicate predicate = IntPredicate.equalTo((int)value);
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(different)).isFalse();
    }

    @Test
    public void lessThan() {
        int value = this.random.nextInt();
        IntPredicate predicate = IntPredicate.lessThan((int)value);
        Assertions.assertThat((boolean)predicate.test(value - 1)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value + 1)).isFalse();
    }

    @Test
    public void greaterThan() {
        int value = this.random.nextInt();
        IntPredicate predicate = IntPredicate.greaterThan((int)value);
        Assertions.assertThat((boolean)predicate.test(value - 1)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value + 1)).isTrue();
    }

    @Test
    public void negate() {
        int value = this.random.nextInt();
        Assertions.assertThat((boolean)IntPredicate.ALWAYS.negate().test(value)).isFalse();
        Assertions.assertThat((boolean)IntPredicate.NEVER.negate().test(value)).isTrue();
    }

    @Test
    public void compose() {
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doCallRealMethod().when((Object)predicate)).compose((ToIntFunction)Mockito.any());
        UUID value = UUID.randomUUID();
        int mapped = this.random.nextInt();
        boolean expected = this.random.nextBoolean();
        ToIntFunction function = (ToIntFunction)Mockito.mock(ToIntFunction.class);
        ((ToIntFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsInt(value);
        ((IntPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.compose(function).test((Object)value)).isEqualTo(expected);
    }

    @Test
    public void composeDouble() {
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeDouble((DoubleToIntFunction)Mockito.any());
        double value = this.random.nextDouble();
        int mapped = this.random.nextInt();
        boolean expected = this.random.nextBoolean();
        DoubleToIntFunction function = (DoubleToIntFunction)Mockito.mock(DoubleToIntFunction.class);
        ((DoubleToIntFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsInt(value);
        ((IntPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeDouble(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeInt() {
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeInt((IntUnaryOperator)Mockito.any());
        int value = this.random.nextInt();
        int mapped = this.random.nextInt();
        boolean expected = this.random.nextBoolean();
        IntUnaryOperator function = (IntUnaryOperator)Mockito.mock(IntUnaryOperator.class);
        ((IntUnaryOperator)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsInt(value);
        ((IntPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeInt(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeLong() {
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeLong((LongToIntFunction)Mockito.any());
        long value = this.random.nextLong();
        int mapped = this.random.nextInt();
        boolean expected = this.random.nextBoolean();
        LongToIntFunction function = (LongToIntFunction)Mockito.mock(LongToIntFunction.class);
        ((LongToIntFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsInt(value);
        ((IntPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeLong(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void xor() {
        IntPredicate predicate1 = (IntPredicate)Mockito.mock(IntPredicate.class);
        IntPredicate predicate2 = (IntPredicate)Mockito.mock(IntPredicate.class);
        ((IntPredicate)Mockito.doCallRealMethod().when((Object)predicate1)).xor((java.util.function.IntPredicate)Mockito.any());
        IntPredicate predicate = predicate1.xor((java.util.function.IntPredicate)predicate2);
        int value = this.random.nextInt();
        ((IntPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate1)).test(value);
        ((IntPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate2)).test(value);
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
    }
}

