/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.IntSupplier;

public class IntSupplierTestCase {
    private final Random random = new Random();

    @Test
    public void apply() {
        int value = this.random.nextInt();
        double expectedDouble = this.random.nextDouble();
        int expectedInt = this.random.nextInt();
        long expectedLong = this.random.nextLong();
        boolean expectedBoolean = this.random.nextBoolean();
        Object expected = new Object();
        IntSupplier supplier = (IntSupplier)Mockito.mock(IntSupplier.class);
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenAccept((IntConsumer)Mockito.any());
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApply((IntFunction)Mockito.any());
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsDouble((IntToDoubleFunction)Mockito.any());
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsInt((IntUnaryOperator)Mockito.any());
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsLong((IntToLongFunction)Mockito.any());
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenTest((java.util.function.IntPredicate)Mockito.any());
        ((IntSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsInt();
        IntFunction function = (IntFunction)Mockito.mock(IntFunction.class);
        IntToDoubleFunction toDoubleFunction = (IntToDoubleFunction)Mockito.mock(IntToDoubleFunction.class);
        IntUnaryOperator toIntFunction = (IntUnaryOperator)Mockito.mock(IntUnaryOperator.class);
        IntToLongFunction toLongFunction = (IntToLongFunction)Mockito.mock(IntToLongFunction.class);
        IntPredicate predicate = (IntPredicate)Mockito.mock(IntPredicate.class);
        IntConsumer consumer = (IntConsumer)Mockito.mock(IntConsumer.class);
        ((IntFunction)Mockito.doReturn((Object)expected).when((Object)function)).apply(value);
        ((IntToDoubleFunction)Mockito.doReturn((Object)expectedDouble).when((Object)toDoubleFunction)).applyAsDouble(value);
        ((IntUnaryOperator)Mockito.doReturn((Object)expectedInt).when((Object)toIntFunction)).applyAsInt(value);
        ((IntToLongFunction)Mockito.doReturn((Object)expectedLong).when((Object)toLongFunction)).applyAsLong(value);
        ((IntPredicate)Mockito.doReturn((Object)expectedBoolean).when((Object)predicate)).test(value);
        Assertions.assertThat((Object)supplier.thenApply(function).get()).isSameAs(expected);
        Assertions.assertThat((double)supplier.thenApplyAsDouble(toDoubleFunction).getAsDouble()).isEqualTo(expectedDouble);
        Assertions.assertThat((int)supplier.thenApplyAsInt(toIntFunction).getAsInt()).isEqualTo(expectedInt);
        Assertions.assertThat((long)supplier.thenApplyAsLong(toLongFunction).getAsLong()).isEqualTo(expectedLong);
        Assertions.assertThat((boolean)supplier.thenTest((java.util.function.IntPredicate)predicate).getAsBoolean()).isEqualTo(expectedBoolean);
        supplier.thenAccept(consumer).run();
        ((IntConsumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void handle() {
        int value = this.random.nextInt();
        IntSupplier supplier = (IntSupplier)Mockito.mock(IntSupplier.class);
        ((IntSupplier)Mockito.doCallRealMethod().when((Object)supplier)).handle((ToIntFunction)Mockito.any());
        ((IntSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsInt();
        ToIntFunction handler = (ToIntFunction)Mockito.mock(ToIntFunction.class);
        int handled = this.random.nextInt();
        RuntimeException exception = new RuntimeException();
        Assertions.assertThat((int)supplier.handle(handler).getAsInt()).isEqualTo(value);
        ((IntSupplier)Mockito.verify((Object)supplier)).getAsInt();
        ((ToIntFunction)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).applyAsInt((RuntimeException)Mockito.any());
        ((IntSupplier)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)supplier)).getAsInt();
        ((ToIntFunction)Mockito.doReturn((Object)handled).when((Object)handler)).applyAsInt(exception);
        Assertions.assertThat((int)supplier.handle(handler).getAsInt()).isEqualTo(handled);
        ((IntSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).getAsInt();
        ((ToIntFunction)Mockito.verify((Object)handler)).applyAsInt((RuntimeException)Mockito.any());
    }

    @Test
    public void of() {
        int expected = this.random.nextInt();
        Assertions.assertThat((int)IntSupplier.of((int)expected).getAsInt()).isEqualTo(expected);
        Assertions.assertThat((int)IntSupplier.ZERO.getAsInt()).isEqualTo(0);
        Assertions.assertThat((int)IntSupplier.MINIMUM.getAsInt()).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)IntSupplier.MAXIMUM.getAsInt()).isEqualTo(Integer.MAX_VALUE);
    }
}

