/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.Random;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.LongConsumer;
import org.wildfly.clustering.function.LongPredicate;
import org.wildfly.clustering.function.LongSupplier;
import org.wildfly.clustering.function.Supplier;

public class LongConsumerTestCase {
    private final Random random = new Random();

    @Test
    public void thenReturn() {
        Object value = new Object();
        Object expected = new Object();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).thenReturn((java.util.function.Supplier)Mockito.any());
        Object result = consumer.thenReturn((java.util.function.Supplier)supplier).apply(value);
        Assertions.assertThat((Object)result).isSameAs(expected);
        ((Consumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void when() {
        long allowed = this.random.nextLong();
        long disallowed = this.random.nextLong();
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(allowed);
        ((LongPredicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(disallowed);
        LongConsumer consumer = (LongConsumer)Mockito.mock(LongConsumer.class);
        ((LongConsumer)Mockito.doCallRealMethod().when((Object)consumer)).when((java.util.function.LongPredicate)Mockito.any());
        LongConsumer conditional = consumer.when((java.util.function.LongPredicate)predicate);
        conditional.accept(disallowed);
        ((LongConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(disallowed);
        conditional.accept(allowed);
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(allowed);
    }

    @Test
    public void withDefault() {
        long allowed = this.random.nextLong();
        long disallowed = this.random.nextLong();
        long defaultValue = this.random.nextLong();
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doReturn((Object)true).when((Object)predicate)).test(allowed);
        ((LongPredicate)Mockito.doReturn((Object)false).when((Object)predicate)).test(disallowed);
        LongConsumer consumer = (LongConsumer)Mockito.mock(LongConsumer.class);
        LongSupplier defaultProvider = (LongSupplier)Mockito.mock(LongSupplier.class);
        ((LongConsumer)Mockito.doCallRealMethod().when((Object)consumer)).withDefault((java.util.function.LongPredicate)Mockito.any(), (java.util.function.LongSupplier)Mockito.any());
        ((LongSupplier)Mockito.doReturn((Object)defaultValue).when((Object)defaultProvider)).getAsLong();
        LongConsumer conditional = consumer.withDefault((java.util.function.LongPredicate)predicate, (java.util.function.LongSupplier)defaultProvider);
        conditional.accept(allowed);
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(allowed);
        Mockito.verifyNoInteractions((Object[])new Object[]{defaultProvider});
        conditional.accept(disallowed);
        ((LongConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(disallowed);
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(defaultValue);
    }

    @Test
    public void compose() {
        LongConsumer consumer = (LongConsumer)Mockito.mock(LongConsumer.class);
        ((LongConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((ToLongFunction)ArgumentMatchers.any());
        ToLongFunction composer = (ToLongFunction)Mockito.mock(ToLongFunction.class);
        Object value = new Object();
        long result = this.random.nextLong();
        ((ToLongFunction)Mockito.doReturn((Object)result).when((Object)composer)).applyAsLong(value);
        consumer.compose(composer).accept(value);
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeAsLong() {
        LongConsumer consumer = (LongConsumer)Mockito.mock(LongConsumer.class);
        ((LongConsumer)Mockito.doCallRealMethod().when((Object)consumer)).composeAsLong((LongUnaryOperator)ArgumentMatchers.any());
        LongUnaryOperator composer = (LongUnaryOperator)Mockito.mock(LongUnaryOperator.class);
        long value = this.random.nextLong();
        long result = this.random.nextLong();
        ((LongUnaryOperator)Mockito.doReturn((Object)result).when((Object)composer)).applyAsLong(value);
        consumer.composeAsLong(composer).accept(value);
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void composeBinary() {
        LongConsumer consumer = (LongConsumer)Mockito.mock(LongConsumer.class);
        ((LongConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((ToLongBiFunction)ArgumentMatchers.any());
        ToLongBiFunction composer = (ToLongBiFunction)Mockito.mock(ToLongBiFunction.class);
        Object key = new Object();
        Object value = new Object();
        long result = this.random.nextLong();
        ((ToLongBiFunction)Mockito.doReturn((Object)result).when((Object)composer)).applyAsLong(key, value);
        consumer.compose(composer).accept(key, value);
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void empty() {
        LongConsumer consumer = LongConsumer.EMPTY;
        consumer.accept(this.random.nextLong());
    }

    @Test
    public void andThen() {
        long value = this.random.nextLong();
        LongConsumer before = (LongConsumer)Mockito.mock(LongConsumer.class);
        ((LongConsumer)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.LongConsumer)Mockito.any());
        LongConsumer after = (LongConsumer)Mockito.mock(LongConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{before, after});
        before.andThen((java.util.function.LongConsumer)after).accept(value);
        ((LongConsumer)order.verify((Object)before)).accept(value);
        ((LongConsumer)order.verify((Object)after)).accept(value);
    }

    @Test
    public void acceptAll() {
        long value = this.random.nextLong();
        LongConsumer consumer1 = (LongConsumer)Mockito.mock(LongConsumer.class);
        LongConsumer consumer2 = (LongConsumer)Mockito.mock(LongConsumer.class);
        LongConsumer consumer3 = (LongConsumer)Mockito.mock(LongConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2, consumer3});
        LongConsumer consumer = LongConsumer.acceptAll(List.of(consumer1, consumer2, consumer3));
        consumer.accept(value);
        ((LongConsumer)order.verify((Object)consumer1)).accept(value);
        ((LongConsumer)order.verify((Object)consumer2)).accept(value);
        ((LongConsumer)order.verify((Object)consumer3)).accept(value);
    }
}

