/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleToLongFunction;
import java.util.function.IntToLongFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.LongPredicate;

public class LongPredicateTestCase {
    private final Random random = new Random();

    @Test
    public void test() {
        long positive = this.random.nextLong(1L, Integer.MAX_VALUE);
        long negative = this.random.nextLong(Integer.MIN_VALUE, 0L);
        Assertions.assertThat((boolean)LongPredicate.ALWAYS.test(negative)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.ALWAYS.test(0L)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.ALWAYS.test(positive)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.NEVER.test(negative)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.NEVER.test(0L)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.NEVER.test(positive)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.of((boolean)true).test(negative)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.of((boolean)true).test(0L)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.of((boolean)true).test(positive)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.of((boolean)false).test(negative)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.of((boolean)false).test(0L)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.of((boolean)false).test(positive)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.NEGATIVE.test(negative)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.NEGATIVE.test(0L)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.NEGATIVE.test(positive)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.ZERO.test(negative)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.ZERO.test(0L)).isTrue();
        Assertions.assertThat((boolean)LongPredicate.ZERO.test(positive)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.POSITIVE.test(negative)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.POSITIVE.test(0L)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.POSITIVE.test(positive)).isTrue();
    }

    @Test
    public void equalTo() {
        long value = this.random.nextLong();
        long different = this.random.nextLong();
        LongPredicate predicate = LongPredicate.equalTo((long)value);
        Assertions.assertThat((boolean)predicate.test(value)).isTrue();
        Assertions.assertThat((boolean)predicate.test(different)).isFalse();
    }

    @Test
    public void lessThan() {
        long value = this.random.nextLong();
        LongPredicate predicate = LongPredicate.lessThan((long)value);
        Assertions.assertThat((boolean)predicate.test(value - 1L)).isTrue();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value + 1L)).isFalse();
    }

    @Test
    public void greaterThan() {
        long value = this.random.nextLong();
        LongPredicate predicate = LongPredicate.greaterThan((long)value);
        Assertions.assertThat((boolean)predicate.test(value - 1L)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value)).isFalse();
        Assertions.assertThat((boolean)predicate.test(value + 1L)).isTrue();
    }

    @Test
    public void negate() {
        long value = this.random.nextLong();
        Assertions.assertThat((boolean)LongPredicate.ALWAYS.negate().test(value)).isFalse();
        Assertions.assertThat((boolean)LongPredicate.NEVER.negate().test(value)).isTrue();
    }

    @Test
    public void compose() {
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doCallRealMethod().when((Object)predicate)).compose((ToLongFunction)Mockito.any());
        UUID value = UUID.randomUUID();
        long mapped = this.random.nextLong();
        boolean expected = this.random.nextBoolean();
        ToLongFunction function = (ToLongFunction)Mockito.mock(ToLongFunction.class);
        ((ToLongFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsLong(value);
        ((LongPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.compose(function).test((Object)value)).isEqualTo(expected);
    }

    @Test
    public void composeDouble() {
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeDouble((DoubleToLongFunction)Mockito.any());
        double value = this.random.nextDouble();
        long mapped = this.random.nextLong();
        boolean expected = this.random.nextBoolean();
        DoubleToLongFunction function = (DoubleToLongFunction)Mockito.mock(DoubleToLongFunction.class);
        ((DoubleToLongFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsLong(value);
        ((LongPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeDouble(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeInt() {
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeInt((IntToLongFunction)Mockito.any());
        int value = this.random.nextInt();
        long mapped = this.random.nextLong();
        boolean expected = this.random.nextBoolean();
        IntToLongFunction function = (IntToLongFunction)Mockito.mock(IntToLongFunction.class);
        ((IntToLongFunction)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsLong(value);
        ((LongPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeInt(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeLong() {
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doCallRealMethod().when((Object)predicate)).composeLong((LongUnaryOperator)Mockito.any());
        long value = this.random.nextLong();
        long mapped = this.random.nextLong();
        boolean expected = this.random.nextBoolean();
        LongUnaryOperator function = (LongUnaryOperator)Mockito.mock(LongUnaryOperator.class);
        ((LongUnaryOperator)Mockito.doReturn((Object)mapped).when((Object)function)).applyAsLong(value);
        ((LongPredicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test(mapped);
        Assertions.assertThat((boolean)predicate.composeLong(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void xor() {
        LongPredicate predicate1 = (LongPredicate)Mockito.mock(LongPredicate.class);
        LongPredicate predicate2 = (LongPredicate)Mockito.mock(LongPredicate.class);
        ((LongPredicate)Mockito.doCallRealMethod().when((Object)predicate1)).xor((java.util.function.LongPredicate)Mockito.any());
        LongPredicate predicate = predicate1.xor((java.util.function.LongPredicate)predicate2);
        int value = this.random.nextInt();
        ((LongPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate1)).test((long)value);
        ((LongPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate2)).test((long)value);
        Assertions.assertThat((boolean)predicate.test((long)value)).isFalse();
        Assertions.assertThat((boolean)predicate.test((long)value)).isTrue();
        Assertions.assertThat((boolean)predicate.test((long)value)).isTrue();
        Assertions.assertThat((boolean)predicate.test((long)value)).isFalse();
    }
}

