/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.LongPredicate;
import org.wildfly.clustering.function.LongSupplier;

public class LongSupplierTestCase {
    private final Random random = new Random();

    @Test
    public void apply() {
        long value = this.random.nextLong();
        double expectedDouble = this.random.nextDouble();
        int expectedInt = this.random.nextInt();
        long expectedLong = this.random.nextLong();
        boolean expectedBoolean = this.random.nextBoolean();
        Object expected = new Object();
        LongSupplier supplier = (LongSupplier)Mockito.mock(LongSupplier.class);
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenAccept((LongConsumer)Mockito.any());
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApply((LongFunction)Mockito.any());
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsDouble((LongToDoubleFunction)Mockito.any());
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsInt((LongToIntFunction)Mockito.any());
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsLong((LongUnaryOperator)Mockito.any());
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).thenTest((java.util.function.LongPredicate)Mockito.any());
        ((LongSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsLong();
        LongFunction function = (LongFunction)Mockito.mock(LongFunction.class);
        LongToDoubleFunction toDoubleFunction = (LongToDoubleFunction)Mockito.mock(LongToDoubleFunction.class);
        LongToIntFunction toIntFunction = (LongToIntFunction)Mockito.mock(LongToIntFunction.class);
        LongUnaryOperator toLongFunction = (LongUnaryOperator)Mockito.mock(LongUnaryOperator.class);
        LongPredicate predicate = (LongPredicate)Mockito.mock(LongPredicate.class);
        LongConsumer consumer = (LongConsumer)Mockito.mock(LongConsumer.class);
        ((LongFunction)Mockito.doReturn((Object)expected).when((Object)function)).apply(value);
        ((LongToDoubleFunction)Mockito.doReturn((Object)expectedDouble).when((Object)toDoubleFunction)).applyAsDouble(value);
        ((LongToIntFunction)Mockito.doReturn((Object)expectedInt).when((Object)toIntFunction)).applyAsInt(value);
        ((LongUnaryOperator)Mockito.doReturn((Object)expectedLong).when((Object)toLongFunction)).applyAsLong(value);
        ((LongPredicate)Mockito.doReturn((Object)expectedBoolean).when((Object)predicate)).test(value);
        Assertions.assertThat((Object)supplier.thenApply(function).get()).isSameAs(expected);
        Assertions.assertThat((double)supplier.thenApplyAsDouble(toDoubleFunction).getAsDouble()).isEqualTo(expectedDouble);
        Assertions.assertThat((int)supplier.thenApplyAsInt(toIntFunction).getAsInt()).isEqualTo(expectedInt);
        Assertions.assertThat((long)supplier.thenApplyAsLong(toLongFunction).getAsLong()).isEqualTo(expectedLong);
        Assertions.assertThat((boolean)supplier.thenTest((java.util.function.LongPredicate)predicate).getAsBoolean()).isEqualTo(expectedBoolean);
        supplier.thenAccept(consumer).run();
        ((LongConsumer)Mockito.verify((Object)consumer)).accept(value);
    }

    @Test
    public void handle() {
        long value = this.random.nextLong();
        LongSupplier supplier = (LongSupplier)Mockito.mock(LongSupplier.class);
        ((LongSupplier)Mockito.doCallRealMethod().when((Object)supplier)).handle((ToLongFunction)Mockito.any());
        ((LongSupplier)Mockito.doReturn((Object)value).when((Object)supplier)).getAsLong();
        ToLongFunction handler = (ToLongFunction)Mockito.mock(ToLongFunction.class);
        long handled = this.random.nextLong();
        RuntimeException exception = new RuntimeException();
        Assertions.assertThat((long)supplier.handle(handler).getAsLong()).isEqualTo(value);
        ((LongSupplier)Mockito.verify((Object)supplier)).getAsLong();
        ((ToLongFunction)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).applyAsLong((RuntimeException)Mockito.any());
        ((LongSupplier)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)supplier)).getAsLong();
        ((ToLongFunction)Mockito.doReturn((Object)handled).when((Object)handler)).applyAsLong(exception);
        Assertions.assertThat((long)supplier.handle(handler).getAsLong()).isEqualTo(handled);
        ((LongSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).getAsLong();
        ((ToLongFunction)Mockito.verify((Object)handler)).applyAsLong((RuntimeException)Mockito.any());
    }

    @Test
    public void of() {
        long expected = this.random.nextLong();
        Assertions.assertThat((long)LongSupplier.of((long)expected).getAsLong()).isEqualTo(expected);
        Assertions.assertThat((long)LongSupplier.ZERO.getAsLong()).isEqualTo(0L);
        Assertions.assertThat((long)LongSupplier.MINIMUM.getAsLong()).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((long)LongSupplier.MAXIMUM.getAsLong()).isEqualTo(Long.MAX_VALUE);
    }
}

