/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleFunction;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.BiPredicate;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;

public class PredicateTestCase {
    private final Random random = new Random();

    @Test
    public void test() {
        UUID value = UUID.randomUUID();
        Assertions.assertThat((boolean)Predicate.always().test((Object)value)).isTrue();
        Assertions.assertThat((boolean)Predicate.always().test(null)).isTrue();
        Assertions.assertThat((boolean)Predicate.never().test((Object)value)).isFalse();
        Assertions.assertThat((boolean)Predicate.never().test(null)).isFalse();
        Assertions.assertThat((boolean)Predicate.of((boolean)true).test((Object)value)).isTrue();
        Assertions.assertThat((boolean)Predicate.of((boolean)true).test(null)).isTrue();
        Assertions.assertThat((boolean)Predicate.of((boolean)false).test((Object)value)).isFalse();
        Assertions.assertThat((boolean)Predicate.of((boolean)false).test(null)).isFalse();
    }

    @Test
    public void equalTo() {
        UUID value = UUID.randomUUID();
        UUID copy = new UUID(value.getMostSignificantBits(), value.getLeastSignificantBits());
        UUID different = UUID.randomUUID();
        Predicate predicate = Predicate.equalTo((Object)value);
        Assertions.assertThat((boolean)predicate.test((Object)value)).isTrue();
        Assertions.assertThat((boolean)predicate.test((Object)copy)).isTrue();
        Assertions.assertThat((boolean)predicate.test((Object)different)).isFalse();
    }

    @Test
    public void identicalTo() {
        UUID value = UUID.randomUUID();
        UUID copy = new UUID(value.getMostSignificantBits(), value.getLeastSignificantBits());
        UUID different = UUID.randomUUID();
        Predicate predicate = Predicate.identicalTo((Object)value);
        Assertions.assertThat((boolean)predicate.test((Object)value)).isTrue();
        Assertions.assertThat((boolean)predicate.test((Object)copy)).isFalse();
        Assertions.assertThat((boolean)predicate.test((Object)different)).isFalse();
    }

    @Test
    public void lessThan() {
        int value = this.random.nextInt();
        Predicate predicate = Predicate.lessThan((Comparable)Integer.valueOf(value));
        Assertions.assertThat((boolean)predicate.test((Object)(value - 1))).isTrue();
        Assertions.assertThat((boolean)predicate.test((Object)value)).isFalse();
        Assertions.assertThat((boolean)predicate.test((Object)(value + 1))).isFalse();
    }

    @Test
    public void greaterThan() {
        int value = this.random.nextInt();
        Predicate predicate = Predicate.greaterThan((Comparable)Integer.valueOf(value));
        Assertions.assertThat((boolean)predicate.test((Object)(value - 1))).isFalse();
        Assertions.assertThat((boolean)predicate.test((Object)value)).isFalse();
        Assertions.assertThat((boolean)predicate.test((Object)(value + 1))).isTrue();
    }

    @Test
    public void negate() {
        UUID value = UUID.randomUUID();
        Assertions.assertThat((boolean)Predicate.of((boolean)true).negate().test((Object)value)).isFalse();
        Assertions.assertThat((boolean)Predicate.of((boolean)true).negate().test(null)).isFalse();
        Assertions.assertThat((boolean)Predicate.of((boolean)false).negate().test((Object)value)).isTrue();
        Assertions.assertThat((boolean)Predicate.of((boolean)false).negate().test(null)).isTrue();
    }

    @Test
    public void compose() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).compose((java.util.function.Function)Mockito.any());
        UUID value = UUID.randomUUID();
        UUID mapped = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doReturn((Object)mapped).when((Object)function)).apply((Object)value);
        ((Predicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test((Object)mapped);
        Assertions.assertThat((boolean)predicate.compose((java.util.function.Function)function).test((Object)value)).isEqualTo(expected);
    }

    @Test
    public void composeDouble() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).composeDouble((DoubleFunction)Mockito.any());
        double value = this.random.nextDouble();
        UUID mapped = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        DoubleFunction function = (DoubleFunction)Mockito.mock(DoubleFunction.class);
        ((DoubleFunction)Mockito.doReturn((Object)mapped).when((Object)function)).apply(value);
        ((Predicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test((Object)mapped);
        Assertions.assertThat((boolean)predicate.composeDouble(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeInt() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).composeInt((IntFunction)Mockito.any());
        int value = this.random.nextInt();
        UUID mapped = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        IntFunction function = (IntFunction)Mockito.mock(IntFunction.class);
        ((IntFunction)Mockito.doReturn((Object)mapped).when((Object)function)).apply(value);
        ((Predicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test((Object)mapped);
        Assertions.assertThat((boolean)predicate.composeInt(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeLong() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).composeLong((LongFunction)Mockito.any());
        long value = this.random.nextLong();
        UUID mapped = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        LongFunction function = (LongFunction)Mockito.mock(LongFunction.class);
        ((LongFunction)Mockito.doReturn((Object)mapped).when((Object)function)).apply(value);
        ((Predicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test((Object)mapped);
        Assertions.assertThat((boolean)predicate.composeLong(function).test(value)).isEqualTo(expected);
    }

    @Test
    public void composeBinary() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).composeBinary((BiFunction)Mockito.any());
        UUID value1 = UUID.randomUUID();
        UUID value2 = UUID.randomUUID();
        UUID mapped = UUID.randomUUID();
        boolean expected = this.random.nextBoolean();
        BiFunction function = (BiFunction)Mockito.mock(BiFunction.class);
        ((BiFunction)Mockito.doReturn((Object)mapped).when((Object)function)).apply((Object)value1, (Object)value2);
        ((Predicate)Mockito.doReturn((Object)expected).when((Object)predicate)).test((Object)mapped);
        Assertions.assertThat((boolean)predicate.composeBinary(function).test((Object)value1, (Object)value2)).isEqualTo(expected);
    }

    @Test
    public void handle() {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        BiPredicate handler = (BiPredicate)Mockito.mock(BiPredicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate)).handle((java.util.function.BiPredicate)Mockito.any());
        UUID goodValue = UUID.randomUUID();
        UUID badValue = UUID.randomUUID();
        RuntimeException exception = new RuntimeException();
        ((Predicate)Mockito.doReturn((Object)false).when((Object)predicate)).test((Object)goodValue);
        ((Predicate)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)predicate)).test((Object)badValue);
        ((BiPredicate)Mockito.doReturn((Object)true).when((Object)handler)).test((Object)badValue, (Object)exception);
        Assertions.assertThat((boolean)predicate.handle((java.util.function.BiPredicate)handler).test((Object)goodValue)).isFalse();
        Assertions.assertThat((boolean)predicate.handle((java.util.function.BiPredicate)handler).test((Object)badValue)).isTrue();
        ((Predicate)Mockito.verify((Object)predicate)).test((Object)goodValue);
        ((Predicate)Mockito.verify((Object)predicate)).test((Object)badValue);
        ((BiPredicate)Mockito.verify((Object)handler)).test((Object)badValue, (Object)exception);
    }

    @Test
    public void xor() {
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doCallRealMethod().when((Object)predicate1)).xor((java.util.function.Predicate)Mockito.any());
        Predicate predicate = predicate1.xor((java.util.function.Predicate)predicate2);
        UUID value = UUID.randomUUID();
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate1)).test((Object)value);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate2)).test((Object)value);
        Assertions.assertThat((boolean)predicate.test((Object)value)).isFalse();
        Assertions.assertThat((boolean)predicate.test((Object)value)).isTrue();
        Assertions.assertThat((boolean)predicate.test((Object)value)).isTrue();
        Assertions.assertThat((boolean)predicate.test((Object)value)).isFalse();
    }

    @Test
    public void entry() {
        Predicate keyPredicate = (Predicate)Mockito.mock(Predicate.class);
        Predicate valuePredicate = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate = Predicate.entry((Predicate)keyPredicate, (Predicate)valuePredicate);
        UUID allowedKey = UUID.randomUUID();
        UUID disallowedKey = UUID.randomUUID();
        UUID allowedValue = UUID.randomUUID();
        UUID disallowedValue = UUID.randomUUID();
        ((Predicate)Mockito.doReturn((Object)false).when((Object)keyPredicate)).test((Object)disallowedKey);
        ((Predicate)Mockito.doReturn((Object)false).when((Object)valuePredicate)).test((Object)disallowedValue);
        ((Predicate)Mockito.doReturn((Object)true).when((Object)keyPredicate)).test((Object)allowedKey);
        ((Predicate)Mockito.doReturn((Object)true).when((Object)valuePredicate)).test((Object)allowedValue);
        Assertions.assertThat((boolean)predicate.test(Map.entry(allowedKey, allowedValue))).isTrue();
        Assertions.assertThat((boolean)predicate.test(Map.entry(allowedKey, disallowedValue))).isFalse();
        Assertions.assertThat((boolean)predicate.test(Map.entry(disallowedKey, allowedValue))).isFalse();
        Assertions.assertThat((boolean)predicate.test(Map.entry(disallowedKey, disallowedValue))).isFalse();
    }
}

