/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Runner;
import org.wildfly.clustering.function.Supplier;

public class RunnerTestCase {
    @Test
    public void andThen() {
        Runner runner1 = (Runner)Mockito.mock(Runner.class);
        Runner runner2 = (Runner)Mockito.mock(Runner.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{runner1, runner2});
        ((Runner)Mockito.doCallRealMethod().when((Object)runner1)).andThen((Runnable)Mockito.any());
        runner1.andThen((Runnable)runner2).run();
        ((Runner)order.verify((Object)runner1)).run();
        ((Runner)order.verify((Object)runner2)).run();
    }

    @Test
    public void compose() {
        Runner runner1 = (Runner)Mockito.mock(Runner.class);
        Runner runner2 = (Runner)Mockito.mock(Runner.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{runner1, runner2});
        ((Runner)Mockito.doCallRealMethod().when((Object)runner2)).compose((Runnable)Mockito.any());
        runner2.compose((Runnable)runner1).run();
        ((Runner)order.verify((Object)runner1)).run();
        ((Runner)order.verify((Object)runner2)).run();
    }

    @Test
    public void handle() {
        Runner runner = (Runner)Mockito.mock(Runner.class);
        Consumer handler = (Consumer)Mockito.mock(Consumer.class);
        RuntimeException exception = new RuntimeException();
        ((Runner)Mockito.doCallRealMethod().when((Object)runner)).handle((Consumer)Mockito.any());
        runner.handle(handler).run();
        ((Runner)Mockito.verify((Object)runner)).run();
        ((Consumer)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).accept((Object)((RuntimeException)Mockito.any()));
        ((Runner)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)runner)).run();
        runner.handle(handler).run();
        ((Consumer)Mockito.verify((Object)handler)).accept((Object)exception);
    }

    @Test
    public void throwing() {
        RuntimeException expected = new RuntimeException();
        Assertions.assertThatThrownBy(() -> Runner.throwing((java.util.function.Supplier)Supplier.of((Object)expected)).run()).isSameAs((Object)expected);
    }

    @Test
    public void runAll() {
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner3 = (Runnable)Mockito.mock(Runnable.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{runner1, runner2, runner3});
        Runner.runAll(List.of(runner1, runner2, runner3)).run();
        ((Runnable)order.verify((Object)runner1)).run();
        ((Runnable)order.verify((Object)runner2)).run();
        ((Runnable)order.verify((Object)runner3)).run();
    }

    @Test
    public void acceptProvided() {
        Object value = new Object();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Runner.accept((java.util.function.Consumer)consumer, (java.util.function.Supplier)Supplier.of((Object)value)).run();
        ((Consumer)Mockito.verify((Object)consumer)).accept(value);
    }
}

