/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Random;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.Callable;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public class SupplierTestCase {
    private final Random random = new Random();

    @Test
    public void apply() {
        Object value = new Object();
        Object expected = new Object();
        boolean expectedBoolean = this.random.nextBoolean();
        double expectedDouble = this.random.nextDouble();
        int expectedInt = this.random.nextInt();
        long expectedLong = this.random.nextLong();
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApply((java.util.function.Function)Mockito.any());
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).thenAccept((Consumer)Mockito.any());
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).thenTest((java.util.function.Predicate)Mockito.any());
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsDouble((ToDoubleFunction)Mockito.any());
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsInt((ToIntFunction)Mockito.any());
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).thenApplyAsLong((ToLongFunction)Mockito.any());
        ((Supplier)Mockito.doReturn((Object)value).when((Object)supplier)).get();
        Function function = (Function)Mockito.mock(Function.class);
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        ToDoubleFunction doubleMapper = (ToDoubleFunction)Mockito.mock(ToDoubleFunction.class);
        ToIntFunction intMapper = (ToIntFunction)Mockito.mock(ToIntFunction.class);
        ToLongFunction longMapper = (ToLongFunction)Mockito.mock(ToLongFunction.class);
        Consumer unaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        ((Function)Mockito.doReturn((Object)expected).when((Object)function)).apply(value);
        ((Predicate)Mockito.doReturn((Object)expectedBoolean).when((Object)predicate)).test(value);
        ((ToDoubleFunction)Mockito.doReturn((Object)expectedDouble).when((Object)doubleMapper)).applyAsDouble(value);
        ((ToIntFunction)Mockito.doReturn((Object)expectedInt).when((Object)intMapper)).applyAsInt(value);
        ((ToLongFunction)Mockito.doReturn((Object)expectedLong).when((Object)longMapper)).applyAsLong(value);
        Assertions.assertThat((Object)supplier.thenApply((java.util.function.Function)function).get()).isSameAs(expected);
        Assertions.assertThat((boolean)supplier.thenTest((java.util.function.Predicate)predicate).getAsBoolean()).isEqualTo(expectedBoolean);
        Assertions.assertThat((double)supplier.thenApplyAsDouble(doubleMapper).getAsDouble()).isEqualTo(expectedDouble);
        Assertions.assertThat((int)supplier.thenApplyAsInt(intMapper).getAsInt()).isEqualTo(expectedInt);
        Assertions.assertThat((long)supplier.thenApplyAsLong(longMapper).getAsLong()).isEqualTo(expectedLong);
        supplier.thenAccept(unaryConsumer).run();
        ((Consumer)Mockito.verify((Object)unaryConsumer)).accept(value);
    }

    @Test
    public void handle() {
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Function handler = (Function)Mockito.mock(Function.class);
        ((Supplier)Mockito.doCallRealMethod().when((Object)supplier)).handle((java.util.function.Function)Mockito.any());
        Object value = new Object();
        Object handled = new Object();
        RuntimeException exception = new RuntimeException();
        ((Supplier)Mockito.doReturn((Object)value).when((Object)supplier)).get();
        Assertions.assertThat((Object)supplier.handle((java.util.function.Function)handler).get()).isSameAs(value);
        ((Supplier)Mockito.verify((Object)supplier)).get();
        ((Function)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).apply((Object)((RuntimeException)Mockito.any()));
        ((Supplier)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)handled).when((Object)handler)).apply((Object)exception);
        Assertions.assertThat((Object)supplier.handle((java.util.function.Function)handler).get()).isSameAs(handled);
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)2))).get();
        ((Function)Mockito.verify((Object)handler)).apply((Object)((RuntimeException)Mockito.any()));
    }

    @Test
    public void of() {
        Object expected = new Object();
        Assertions.assertThat((Object)Supplier.of((Object)expected).get()).isSameAs(expected);
        Assertions.assertThat((Object)Supplier.of(null).get()).isNull();
    }

    @Test
    public void run() {
        Runnable runner = (Runnable)Mockito.mock(Runnable.class);
        Assertions.assertThat((Object)Supplier.run((Runnable)runner).get()).isNull();
        ((Runnable)Mockito.verify((Object)runner)).run();
        Assertions.assertThat((Object)Supplier.run(null).get()).isNull();
    }

    @Test
    public void call() throws Exception {
        Callable caller = (Callable)Mockito.mock(Callable.class);
        Function handler = (Function)Mockito.mock(Function.class);
        Assertions.assertThat((Object)Supplier.call((java.util.concurrent.Callable)caller, (java.util.function.Function)handler).get()).isNull();
        ((Callable)Mockito.verify((Object)caller)).call();
        ((Function)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).apply((Object)((Exception)Mockito.any()));
        Object result = new Object();
        ((Callable)Mockito.doReturn((Object)result).when((Object)caller)).call();
        Assertions.assertThat((Object)Supplier.call((java.util.concurrent.Callable)caller, (java.util.function.Function)handler).get()).isSameAs(result);
        ((Callable)Mockito.verify((Object)caller, (VerificationMode)Mockito.times((int)2))).call();
        ((Function)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).apply((Object)((Exception)Mockito.any()));
        Exception exception = new Exception();
        Object handled = new Object();
        ((Callable)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)caller)).call();
        ((Function)Mockito.doReturn((Object)handled).when((Object)handler)).apply((Object)exception);
        Assertions.assertThat((Object)Supplier.call((java.util.concurrent.Callable)caller, (java.util.function.Function)handler).get()).isSameAs(handled);
        ((Callable)Mockito.verify((Object)caller, (VerificationMode)Mockito.times((int)3))).call();
        ((Function)Mockito.verify((Object)handler)).apply((Object)exception);
    }
}

