/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.BinaryOperator;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.function.UnaryOperator;

public class UnaryOperatorTestCase {
    @Test
    public void compose() {
        UnaryOperator function = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((UnaryOperator)Mockito.doCallRealMethod().when((Object)function)).compose((java.util.function.UnaryOperator)ArgumentMatchers.any());
        UnaryOperator mapper = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UUID value = UUID.randomUUID();
        UUID mapped = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        ((UnaryOperator)Mockito.doReturn((Object)mapped).when((Object)mapper)).apply((Object)value);
        ((UnaryOperator)Mockito.doReturn((Object)expected).when((Object)function)).apply((Object)mapped);
        Assertions.assertThat((Comparable)((UUID)function.compose((java.util.function.UnaryOperator)mapper).apply((Object)value))).isSameAs((Object)expected);
        ((UnaryOperator)Mockito.verify((Object)function)).apply((Object)mapped);
    }

    @Test
    public void composeBinary() {
        UnaryOperator function = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((UnaryOperator)Mockito.doCallRealMethod().when((Object)function)).compose((BiFunction)ArgumentMatchers.any());
        BinaryOperator mapper = (BinaryOperator)Mockito.mock(BinaryOperator.class);
        UUID value1 = UUID.randomUUID();
        UUID value2 = UUID.randomUUID();
        UUID mapped = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        ((BinaryOperator)Mockito.doReturn((Object)mapped).when((Object)mapper)).apply((Object)value1, (Object)value2);
        ((UnaryOperator)Mockito.doReturn((Object)expected).when((Object)function)).apply((Object)mapped);
        Assertions.assertThat((Comparable)((UUID)function.compose((BiFunction)mapper).apply((Object)value1, (Object)value2))).isSameAs((Object)expected);
        ((UnaryOperator)Mockito.verify((Object)function)).apply((Object)mapped);
    }

    @Test
    public void empty() {
        Assertions.assertThat((Object)Function.empty().apply((Object)UUID.randomUUID())).isNull();
    }

    @Test
    public void of() {
        UUID parameter = UUID.randomUUID();
        UUID expected = UUID.randomUUID();
        Assertions.assertThat((Comparable)((UUID)Function.of((Object)expected).apply((Object)parameter))).isSameAs((Object)expected);
        Assertions.assertThat((Object)Function.of(null).apply((Object)parameter)).isNull();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        Assertions.assertThat((Comparable)((UUID)Function.of((java.util.function.Consumer)consumer, (java.util.function.Supplier)supplier).apply((Object)parameter))).isSameAs((Object)expected);
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.only())).accept((Object)parameter);
        ((Supplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.only())).get();
    }

    @Test
    public void withDefault() {
        UUID result = UUID.randomUUID();
        UUID value = UUID.randomUUID();
        UUID defaultValue = UUID.randomUUID();
        UUID defaultResult = UUID.randomUUID();
        UnaryOperator function = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((UnaryOperator)Mockito.doCallRealMethod().when((Object)function)).withDefault((java.util.function.Predicate)ArgumentMatchers.any(), (java.util.function.Supplier)ArgumentMatchers.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test((Object)value);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((UnaryOperator)Mockito.doReturn((Object)result).when((Object)function)).apply((Object)value);
        ((UnaryOperator)Mockito.doReturn((Object)defaultResult).when((Object)function)).apply((Object)defaultValue);
        Assertions.assertThat((Comparable)((UUID)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)defaultResult);
        Assertions.assertThat((Comparable)((UUID)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)result);
    }

    @Test
    public void orDefault() {
        UUID result = UUID.randomUUID();
        UUID value = UUID.randomUUID();
        UUID defaultResult = UUID.randomUUID();
        UnaryOperator function = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        ((UnaryOperator)Mockito.doCallRealMethod().when((Object)function)).orDefault((java.util.function.Predicate)ArgumentMatchers.any(), (java.util.function.Supplier)ArgumentMatchers.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test((Object)value);
        ((Supplier)Mockito.doReturn((Object)defaultResult).when((Object)supplier)).get();
        ((UnaryOperator)Mockito.doReturn((Object)result).when((Object)function)).apply((Object)value);
        Assertions.assertThat((Comparable)((UUID)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)defaultResult);
        Assertions.assertThat((Comparable)((UUID)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply((Object)value))).isSameAs((Object)result);
    }

    @Test
    public void entry() {
        UnaryOperator keyFunction = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UnaryOperator valueFunction = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        UUID sourceKey = UUID.randomUUID();
        UUID resultKey = UUID.randomUUID();
        UUID sourceValue = UUID.randomUUID();
        UUID resultValue = UUID.randomUUID();
        ((UnaryOperator)Mockito.doReturn((Object)resultKey).when((Object)keyFunction)).apply((Object)sourceKey);
        ((UnaryOperator)Mockito.doReturn((Object)resultValue).when((Object)valueFunction)).apply((Object)sourceValue);
        UnaryOperator function = UnaryOperator.entry((UnaryOperator)keyFunction, (UnaryOperator)valueFunction);
        Map.Entry result = (Map.Entry)function.apply(Map.entry(sourceKey, sourceValue));
        Assertions.assertThat((Comparable)((UUID)result.getKey())).isSameAs((Object)resultKey);
        Assertions.assertThat((Comparable)((UUID)result.getValue())).isSameAs((Object)resultValue);
    }
}

