/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;

public interface BiFunction<T, U, R>
extends java.util.function.BiFunction<T, U, R> {
    public static final BiFunction<?, ?, ?> FORMER_IDENTITY = (value1, value2) -> value1;
    public static final BiFunction<?, ?, ?> LATTER_IDENTITY = (value1, value2) -> value2;
    public static final BiFunction<?, ?, ?> NULL = (value1, value2) -> null;

    default public <V1, V2> BiFunction<V1, V2, R> compose(final java.util.function.Function<? super V1, ? extends T> before1, final java.util.function.Function<? super V2, ? extends U> before2) {
        return new BiFunction<V1, V2, R>(this){
            final /* synthetic */ BiFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(V1 value1, V2 value2) {
                return this.this$0.apply(before1.apply(value1), before2.apply(value2));
            }
        };
    }

    default public <V> Function<V, R> composeUnary(final java.util.function.Function<? super V, ? extends T> before1, final java.util.function.Function<? super V, ? extends U> before2) {
        return new Function<V, R>(this){
            final /* synthetic */ BiFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(V value) {
                return this.this$0.apply(before1.apply(value), before2.apply(value));
            }
        };
    }

    @Override
    default public <V> BiFunction<T, U, V> andThen(final java.util.function.Function<? super R, ? extends V> after) {
        return new BiFunction<T, U, V>(this){
            final /* synthetic */ BiFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public V apply(T value1, U value2) {
                return after.apply(this.this$0.apply(value1, value2));
            }
        };
    }

    default public BiFunction<U, T, R> reverse() {
        return new BiFunction<U, T, R>(){

            @Override
            public R apply(U value2, T value1) {
                return BiFunction.this.apply(value1, value2);
            }
        };
    }

    default public BiFunction<T, U, R> withDefault(final Predicate<T> predicate1, final java.util.function.Supplier<T> defaultValue1, final Predicate<U> predicate2, final java.util.function.Supplier<U> defaultValue2) {
        return new BiFunction<T, U, R>(this){
            final /* synthetic */ BiFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value1, U value2) {
                return this.this$0.apply(predicate1.test(value1) ? value1 : defaultValue1.get(), predicate2.test(value2) ? value2 : defaultValue2.get());
            }
        };
    }

    default public BiFunction<T, U, R> orDefault(final BiPredicate<T, U> predicate, final java.util.function.Supplier<R> defaultResult) {
        return new BiFunction<T, U, R>(this){
            final /* synthetic */ BiFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value1, U value2) {
                return predicate.test(value1, value2) ? this.this$0.apply(value1, value2) : defaultResult.get();
            }
        };
    }

    public static <T extends R, U, R> BiFunction<T, U, R> former() {
        return FORMER_IDENTITY;
    }

    public static <T, U extends R, R> BiFunction<T, U, R> latter() {
        return LATTER_IDENTITY;
    }

    public static <T, U, R> BiFunction<T, U, R> empty() {
        return NULL;
    }

    public static <T, U, R> BiFunction<T, U, R> of(R result) {
        return result != null ? BiFunction.of(BiConsumer.empty(), Supplier.of(result)) : BiFunction.empty();
    }

    public static <T, U, R> BiFunction<T, U, R> of(final java.util.function.BiConsumer<T, U> consumer, final java.util.function.Supplier<R> supplier) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value1, U value2) {
                consumer.accept(value1, value2);
                return supplier.get();
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> applyFormer(final java.util.function.Function<T, R> function) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T value, U ignored) {
                return function.apply(value);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> applyLatter(final java.util.function.Function<U, R> function) {
        return new BiFunction<T, U, R>(){

            @Override
            public R apply(T ignored, U value) {
                return function.apply(value);
            }
        };
    }
}

