/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.ToDoubleFunction;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.DoubleConsumer;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.LongPredicate;
import org.wildfly.clustering.function.Predicate;

public interface DoublePredicate
extends java.util.function.DoublePredicate {
    public static final DoublePredicate ALWAYS = DoublePredicate.of(DoubleConsumer.EMPTY, BooleanSupplier.TRUE);
    public static final DoublePredicate NEVER = DoublePredicate.of(DoubleConsumer.EMPTY, BooleanSupplier.FALSE);
    public static final DoublePredicate POSITIVE = DoublePredicate.greaterThan(0.0);
    public static final DoublePredicate ZERO = DoublePredicate.equalTo(0.0);
    public static final DoublePredicate NEGATIVE = DoublePredicate.lessThan(0.0);

    default public <V> Predicate<V> compose(final ToDoubleFunction<V> function) {
        return new Predicate<V>(this){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(V value) {
                return this.this$0.test(function.applyAsDouble(value));
            }
        };
    }

    default public DoublePredicate composeDouble(final DoubleUnaryOperator function) {
        return new DoublePredicate(){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(function.applyAsDouble(value));
            }
        };
    }

    default public IntPredicate composeInt(final IntToDoubleFunction function) {
        return new IntPredicate(){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(function.applyAsDouble(value));
            }
        };
    }

    default public LongPredicate composeLong(final LongToDoubleFunction function) {
        return new LongPredicate(){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(function.applyAsDouble(value));
            }
        };
    }

    @Override
    default public DoublePredicate and(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public DoublePredicate negate() {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return !DoublePredicate.this.test(value);
            }
        };
    }

    @Override
    default public DoublePredicate or(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(value) || other.test(value);
            }
        };
    }

    default public DoublePredicate xor(final java.util.function.DoublePredicate other) {
        return new DoublePredicate(){
            final /* synthetic */ DoublePredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(value) ^ other.test(value);
            }
        };
    }

    public static DoublePredicate of(boolean result) {
        return result ? ALWAYS : NEVER;
    }

    public static DoublePredicate of(final java.util.function.DoubleConsumer consumer, final java.util.function.BooleanSupplier supplier) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                consumer.accept(value);
                return supplier.getAsBoolean();
            }
        };
    }

    public static DoublePredicate lessThan(final double base) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Double.compare(value, base) < 0;
            }
        };
    }

    public static DoublePredicate equalTo(final double base) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Double.compare(base, value) == 0;
            }
        };
    }

    public static DoublePredicate greaterThan(final double base) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Double.compare(value, base) > 0;
            }
        };
    }
}

