/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;

public interface Function<T, R>
extends java.util.function.Function<T, R> {
    public static final Function<?, ?> IDENTITY = value -> value;
    public static final Function<?, ?> NULL = Function.of(Consumer.EMPTY, Supplier.NULL);

    @Override
    default public <V> Function<V, R> compose(final java.util.function.Function<? super V, ? extends T> before) {
        return new Function<V, R>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(V value) {
                return this.this$0.apply(before.apply(value));
            }
        };
    }

    default public <V1, V2> BiFunction<V1, V2, R> compose(final BiFunction<V1, V2, T> mapper) {
        return new BiFunction<V1, V2, R>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(V1 value1, V2 value2) {
                return this.this$0.apply(mapper.apply(value1, value2));
            }
        };
    }

    @Override
    default public <V> Function<T, V> andThen(final java.util.function.Function<? super R, ? extends V> after) {
        return new Function<T, V>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public V apply(T value) {
                return after.apply(this.this$0.apply(value));
            }
        };
    }

    default public Function<T, R> withDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultValue) {
        return new Function<T, R>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value) {
                return this.this$0.apply(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public Function<T, R> orDefault(final Predicate<T> predicate, final java.util.function.Supplier<R> defaultResult) {
        return new Function<T, R>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value) {
                return predicate.test(value) ? this.this$0.apply(value) : defaultResult.get();
            }
        };
    }

    default public Function<T, R> handle(final java.util.function.BiFunction<T, RuntimeException, R> handler) {
        return new Function<T, R>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(T value) {
                try {
                    return this.this$0.apply(value);
                }
                catch (RuntimeException e) {
                    return handler.apply(value, e);
                }
            }
        };
    }

    default public Function<Optional<T>, Optional<R>> optional() {
        return new Function<Optional<T>, Optional<R>>(){

            @Override
            public Optional<R> apply(Optional<T> value) {
                return value.map(Function.this);
            }
        };
    }

    default public <M> Function<T, R> withMonitor(final java.util.function.Function<T, M> monitorFunction) {
        return new Function<T, R>(this){
            final /* synthetic */ Function this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T value) {
                Object monitor = monitorFunction.apply(value);
                if (monitor != null) {
                    Object r = monitor;
                    synchronized (r) {
                        return this.this$0.apply(value);
                    }
                }
                return this.this$0.apply(value);
            }
        };
    }

    public static <T extends R, R> Function<T, R> identity() {
        return IDENTITY;
    }

    public static <T, R> Function<T, R> empty() {
        return NULL;
    }

    public static <T, R> Function<T, R> of(R result) {
        return result != null ? Function.of(Consumer.empty(), Supplier.of(result)) : Function.empty();
    }

    public static <T, R> Function<T, R> of(final java.util.function.Consumer<T> consumer, final java.util.function.Supplier<R> supplier) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                consumer.accept(value);
                return supplier.get();
            }
        };
    }

    public static <K, V, KR, VR> Function<Map.Entry<K, V>, Map.Entry<KR, VR>> entry(final Function<K, KR> keyFunction, final Function<V, VR> valueFunction) {
        return new Function<Map.Entry<K, V>, Map.Entry<KR, VR>>(){

            @Override
            public Map.Entry<KR, VR> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
            }
        };
    }
}

