/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleToLongFunction;
import java.util.function.IntToLongFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.wildfly.clustering.function.BooleanSupplier;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.LongConsumer;
import org.wildfly.clustering.function.Predicate;

public interface LongPredicate
extends java.util.function.LongPredicate {
    public static final LongPredicate ALWAYS = LongPredicate.of(LongConsumer.EMPTY, BooleanSupplier.TRUE);
    public static final LongPredicate NEVER = LongPredicate.of(LongConsumer.EMPTY, BooleanSupplier.FALSE);
    public static final LongPredicate POSITIVE = LongPredicate.greaterThan(0L);
    public static final LongPredicate ZERO = LongPredicate.equalTo(0L);
    public static final LongPredicate NEGATIVE = LongPredicate.lessThan(0L);

    default public <V> Predicate<V> compose(final ToLongFunction<V> function) {
        return new Predicate<V>(this){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(V value) {
                return this.this$0.test(function.applyAsLong(value));
            }
        };
    }

    default public DoublePredicate composeDouble(final DoubleToLongFunction function) {
        return new DoublePredicate(){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(double value) {
                return this.this$0.test(function.applyAsLong(value));
            }
        };
    }

    default public IntPredicate composeInt(final IntToLongFunction function) {
        return new IntPredicate(){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(int value) {
                return this.this$0.test(function.applyAsLong(value));
            }
        };
    }

    default public LongPredicate composeLong(final LongUnaryOperator function) {
        return new LongPredicate(){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(function.applyAsLong(value));
            }
        };
    }

    @Override
    default public LongPredicate and(final java.util.function.LongPredicate other) {
        return new LongPredicate(){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public LongPredicate negate() {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return !LongPredicate.this.test(value);
            }
        };
    }

    @Override
    default public LongPredicate or(final java.util.function.LongPredicate other) {
        return new LongPredicate(){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(value) || other.test(value);
            }
        };
    }

    default public LongPredicate xor(final java.util.function.LongPredicate other) {
        return new LongPredicate(){
            final /* synthetic */ LongPredicate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(long value) {
                return this.this$0.test(value) ^ other.test(value);
            }
        };
    }

    public static LongPredicate of(boolean result) {
        return result ? ALWAYS : NEVER;
    }

    public static LongPredicate of(final java.util.function.LongConsumer consumer, final java.util.function.BooleanSupplier supplier) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                consumer.accept(value);
                return supplier.getAsBoolean();
            }
        };
    }

    public static LongPredicate lessThan(final long base) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return (long)Long.compare(value, base) < 0L;
            }
        };
    }

    public static LongPredicate equalTo(final long base) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return (long)Long.compare(base, value) == 0L;
            }
        };
    }

    public static LongPredicate greaterThan(final long base) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return (long)Long.compare(value, base) > 0L;
            }
        };
    }
}

