/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.wildfly.clustering.function.Consumer;

public interface Runner
extends Runnable {
    public static final Runner EMPTY = () -> {};

    default public Runner andThen(Runnable after) {
        return Runner.runAll(List.of(this, after));
    }

    default public Runner compose(Runnable before) {
        return Runner.runAll(List.of(before, this));
    }

    default public Runner handle(final Consumer<RuntimeException> handler) {
        return new Runner(){
            final /* synthetic */ Runner this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.run();
                }
                catch (RuntimeException e) {
                    handler.accept(e);
                }
            }
        };
    }

    public static Runner empty() {
        return EMPTY;
    }

    public static Runner throwing(final Supplier<RuntimeException> exceptionProvider) {
        return new Runner(){

            @Override
            public void run() {
                throw (RuntimeException)exceptionProvider.get();
            }
        };
    }

    public static <T> Runner accept(final java.util.function.Consumer<? super T> consumer, final Supplier<? extends T> supplier) {
        return new Runner(){

            @Override
            public void run() {
                consumer.accept(supplier.get());
            }
        };
    }

    public static Runner accept(final DoubleConsumer consumer, final DoubleSupplier supplier) {
        return new Runner(){

            @Override
            public void run() {
                consumer.accept(supplier.getAsDouble());
            }
        };
    }

    public static Runner accept(final IntConsumer consumer, final IntSupplier supplier) {
        return new Runner(){

            @Override
            public void run() {
                consumer.accept(supplier.getAsInt());
            }
        };
    }

    public static Runner accept(final LongConsumer consumer, final LongSupplier supplier) {
        return new Runner(){

            @Override
            public void run() {
                consumer.accept(supplier.getAsLong());
            }
        };
    }

    public static Runner runAll(final Iterable<? extends Runnable> runners) {
        return new Runner(){

            @Override
            public void run() {
                runners.forEach(Runnable::run);
            }
        };
    }
}

