/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.Serializable;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.Serializer;
import org.wildfly.clustering.marshalling.java.ObjectInputStream;
import org.wildfly.clustering.marshalling.java.ObjectOutputStream;

public class JavaByteBufferMarshaller
implements ByteBufferMarshaller {
    private final Serializer<ClassLoader> classLoaderSerializer;

    public JavaByteBufferMarshaller(ClassLoader loader) {
        this((Serializer<ClassLoader>)Serializer.of((Object)loader));
    }

    public JavaByteBufferMarshaller(Serializer<ClassLoader> classLoaderSerializer) {
        this.classLoaderSerializer = classLoaderSerializer;
    }

    public boolean isMarshallable(Object object) {
        return object == null || object instanceof Serializable;
    }

    public Object readFrom(InputStream in) throws IOException {
        Object object;
        ObjectInputStream input = new ObjectInputStream(in, this.classLoaderSerializer);
        try {
            object = input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                InvalidClassException exception = new InvalidClassException(e.getMessage());
                exception.initCause(e);
                throw exception;
            }
        }
        input.close();
        return object;
    }

    public void writeTo(OutputStream out, Object object) throws IOException {
        try (ObjectOutputStream output = new ObjectOutputStream(out, this.classLoaderSerializer);){
            output.writeObject(object);
        }
    }
}

