/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.java;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.wildfly.clustering.marshalling.Serializer;

public class ObjectOutputStream
extends java.io.ObjectOutputStream {
    private final Serializer<ClassLoader> seralizer;

    public ObjectOutputStream(OutputStream output, Serializer<ClassLoader> seralizer) throws IOException {
        super(output);
        this.seralizer = seralizer;
    }

    @Override
    protected void annotateClass(Class<?> targetClass) throws IOException {
        this.seralizer.write((DataOutput)this, (Object)targetClass.getClassLoader());
    }

    @Override
    protected void annotateProxyClass(Class<?> proxyClass) throws IOException {
        for (Class<?> interfaceClass : proxyClass.getInterfaces()) {
            this.seralizer.write((DataOutput)this, (Object)interfaceClass.getClassLoader());
        }
        this.seralizer.write((DataOutput)this, (Object)proxyClass.getClassLoader());
    }
}

