/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.java;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.wildfly.clustering.marshalling.Serializer;

public class ObjectOutputStream
extends java.io.ObjectOutputStream {
    private final Serializer<ClassLoader> serializer;

    public ObjectOutputStream(OutputStream output, Serializer<ClassLoader> serializer) throws IOException {
        super(output);
        this.serializer = serializer;
    }

    @Override
    protected void annotateClass(Class<?> targetClass) throws IOException {
        this.serializer.write((DataOutput)this, (Object)ObjectOutputStream.getClassLoader(targetClass));
    }

    @Override
    protected void annotateProxyClass(Class<?> proxyClass) throws IOException {
        for (Class<?> interfaceClass : proxyClass.getInterfaces()) {
            this.serializer.write((DataOutput)this, (Object)ObjectOutputStream.getClassLoader(interfaceClass));
        }
        this.serializer.write((DataOutput)this, (Object)ObjectOutputStream.getClassLoader(proxyClass));
    }

    private static ClassLoader getClassLoader(final Class<?> targetClass) {
        if (System.getSecurityManager() == null) {
            return targetClass.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return targetClass.getClassLoader();
            }
        });
    }
}

