/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.List;
import java.util.function.Supplier;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferTestMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TestMarshaller;
import org.wildfly.clustering.marshalling.java.JavaTesterFactory;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.LoadedClassTable;
import org.wildfly.clustering.marshalling.jboss.LoadedObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;

public enum JBossTesterFactory implements MarshallingTesterFactory,
Supplier<ByteBufferMarshaller>
{
    INSTANCE;

    private final ByteBufferMarshaller marshaller;

    private JBossTesterFactory() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassTable((ClassTable)new LoadedClassTable(loader));
        configuration.setObjectTable((ObjectTable)new LoadedObjectTable(loader));
        this.marshaller = new JBossByteBufferMarshaller(MarshallingConfigurationRepository.from((MarshallingConfiguration[])new MarshallingConfiguration[]{configuration}), loader);
    }

    public <T> MarshallingTester<T> createTester() {
        return new MarshallingTester((TestMarshaller)new ByteBufferTestMarshaller(this.marshaller), List.of(JavaTesterFactory.INSTANCE.get()));
    }

    @Override
    public ByteBufferMarshaller get() {
        return this.marshaller;
    }
}

