/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.util.List;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.jboss.IdentityTable;

public class IdentityClassTable
implements ClassTable {
    private final IdentityTable<Class<?>> table;
    private final ClassTable.Writer writer;

    public IdentityClassTable(List<Class<?>> classes) {
        this.table = IdentityTable.from(List.copyOf(classes));
        this.writer = (marshaller, targetClass) -> this.table.findWriter(targetClass).accept((Object)marshaller, (Object)targetClass);
    }

    public ClassTable.Writer getClassWriter(Class<?> targetClass) throws IOException {
        return this.table.findWriter(targetClass) != null ? this.writer : null;
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        return this.table.read(unmarshaller);
    }
}

