/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.List;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.java.JavaTesterFactory;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.LoadedClassTable;
import org.wildfly.clustering.marshalling.jboss.LoadedObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;

public enum JBossTesterFactory implements MarshallingTesterFactory
{
    INSTANCE;

    private final ByteBufferMarshaller marshaller;

    private JBossTesterFactory() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassTable((ClassTable)new LoadedClassTable(loader));
        configuration.setObjectTable((ObjectTable)new LoadedObjectTable(loader));
        this.marshaller = new JBossByteBufferMarshaller(MarshallingConfigurationRepository.from((MarshallingConfiguration[])new MarshallingConfiguration[]{configuration}), loader);
    }

    public ByteBufferMarshaller getMarshaller() {
        return this.marshaller;
    }

    public List<ByteBufferMarshaller> getBenchmarkMarshallers() {
        return List.of(JavaTesterFactory.INSTANCE.getMarshaller());
    }
}

