/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;

class Reflect {
    Reflect() {
    }

    static <T> void loadAll(final Class<T> targetClass, final ClassLoader loader, final Consumer<T> consumer) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ServiceLoader.load(targetClass, loader).forEach(consumer);
                return null;
            }
        });
    }

    static <T> void loadSingle(final Class<T> targetClass, final ClassLoader loader, Consumer<T> consumer) {
        Optional service = (Optional)AccessController.doPrivileged(new PrivilegedAction<Optional<T>>(){

            @Override
            public Optional<T> run() {
                return ServiceLoader.load(targetClass, loader).findFirst();
            }
        });
        service.ifPresent(consumer);
    }

    static ClassLoader setThreadContextClassLoader(final ClassLoader loader) {
        final Thread thread = Thread.currentThread();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader currentLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(loader);
                return currentLoader;
            }
        });
    }
}

