/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.marshalling.ChainingClassTable;
import org.jboss.marshalling.ClassTable;
import org.wildfly.clustering.marshalling.jboss.DefaultClassTableProvider;

public class LoadedClassTable
extends ChainingClassTable {
    public LoadedClassTable(ClassLoader loader) {
        this(List.of(loader));
    }

    public LoadedClassTable(List<ClassLoader> loaders) {
        super(LoadedClassTable.load(loaders));
    }

    private static ClassTable[] load(List<ClassLoader> loaders) {
        ArrayList loadedTables = new ArrayList(loaders.size());
        for (ClassLoader loader : loaders) {
            ServiceLoader.load(ClassTable.class, loader).findFirst().ifPresent(loadedTables::add);
        }
        Stream<ClassTable> tables = EnumSet.allOf(DefaultClassTableProvider.class).stream().map(Supplier::get);
        if (!loadedTables.isEmpty()) {
            tables = Stream.concat(tables, loadedTables.stream());
        }
        return (ClassTable[])tables.toArray(ClassTable[]::new);
    }
}

