/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.marshalling.ChainingClassTable;
import org.jboss.marshalling.ChainingObjectTable;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.MappingClassExternalizerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.wildfly.clustering.marshalling.MarshallerConfigurationBuilder;
import org.wildfly.clustering.marshalling.jboss.DefaultClassTableProvider;
import org.wildfly.clustering.marshalling.jboss.DefaultObjectTableProvider;
import org.wildfly.clustering.marshalling.jboss.ExternalizerProvider;
import org.wildfly.clustering.marshalling.jboss.IdentityClassTable;
import org.wildfly.clustering.marshalling.jboss.IdentityObjectTable;

public interface MarshallingConfigurationBuilder
extends MarshallerConfigurationBuilder<MarshallingConfiguration, ExternalizerProvider, MarshallingConfigurationBuilder> {
    public static MarshallingConfigurationBuilder newInstance(ClassResolver resolver) {
        return new DefaultMarshallingConfigurationBuilder(resolver);
    }

    public static class DefaultMarshallingConfigurationBuilder
    implements MarshallingConfigurationBuilder {
        private final MarshallingConfiguration configuration = new MarshallingConfiguration();
        private final Map<Class<?>, Externalizer> externalizers = new LinkedHashMap();
        private final Stream.Builder<ClassTable> classTables = Stream.builder();
        private final Stream.Builder<ObjectTable> objectTables = Stream.builder();

        DefaultMarshallingConfigurationBuilder(ClassResolver resolver) {
            this.configuration.setClassResolver(resolver);
            this.configuration.setSerializabilityChecker(SerializabilityChecker.DEFAULT);
            EnumSet.allOf(DefaultClassTableProvider.class).stream().map(Supplier::get).forEach(this.classTables);
            EnumSet.allOf(DefaultObjectTableProvider.class).stream().map(Supplier::get).forEach(this.objectTables);
        }

        public MarshallingConfigurationBuilder register(ExternalizerProvider provider) {
            this.externalizers.put(provider.getType(), provider.getExternalizer());
            return this;
        }

        public MarshallingConfigurationBuilder load(ClassLoader loader) {
            DefaultMarshallingConfigurationBuilder.loadAll(ExternalizerProvider.class, loader, this::register);
            DefaultMarshallingConfigurationBuilder.loadAll(ClassTable.class, loader, this.classTables);
            DefaultMarshallingConfigurationBuilder.loadAll(ObjectTable.class, loader, this.objectTables);
            return this;
        }

        public MarshallingConfiguration build() {
            if (!this.externalizers.isEmpty()) {
                this.classTables.add(new IdentityClassTable(new ArrayList(this.externalizers.keySet())));
                this.objectTables.add(new IdentityObjectTable(new ArrayList<Externalizer>(this.externalizers.values())));
            }
            this.configuration.setClassExternalizerFactory((ClassExternalizerFactory)new MappingClassExternalizerFactory(this.externalizers));
            this.configuration.setClassTable((ClassTable)new ChainingClassTable((ClassTable[])this.classTables.build().toArray(ClassTable[]::new)));
            this.configuration.setObjectTable((ObjectTable)new ChainingObjectTable((ObjectTable[])this.objectTables.build().toArray(ObjectTable[]::new)));
            return this.configuration;
        }

        static <T> void loadAll(Class<T> targetClass, ClassLoader loader, Consumer<T> consumer) {
            ServiceLoader.load(targetClass, loader).stream().map(Supplier::get).forEach(consumer);
        }
    }
}

