/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.List;
import java.util.function.Supplier;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferTestMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TestMarshaller;
import org.wildfly.clustering.marshalling.java.JavaTesterFactory;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;

public class ProtoStreamTesterFactory
implements MarshallingTesterFactory,
Supplier<ByteBufferMarshaller> {
    private final ByteBufferMarshaller marshaller;

    public ProtoStreamTesterFactory() {
        this(List.of());
    }

    public ProtoStreamTesterFactory(Iterable<SerializationContextInitializer> initializers) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        ImmutableSerializationContext context = SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader).register(initializers).build();
        this.marshaller = new ProtoStreamByteBufferMarshaller(context);
    }

    public <T> MarshallingTester<T> createTester() {
        return new MarshallingTester((TestMarshaller)new ByteBufferTestMarshaller(this.marshaller), List.of(JavaTesterFactory.INSTANCE.get()));
    }

    @Override
    public ByteBufferMarshaller get() {
        return this.marshaller;
    }
}

