/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.AnySerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContext;
import org.wildfly.clustering.marshalling.protostream.LangSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.MarshallingSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.Reflect;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.math.MathSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.net.NetSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.sql.SQLSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.time.TimeSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.util.UtilSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.util.concurrent.ConcurrentSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.util.concurrent.atomic.AtomicSerializationContextInitializer;

public interface SerializationContextBuilder {
    public static SerializationContextBuilder newInstance(ClassLoaderMarshaller marshaller) {
        return new DefaultSerializationContextBuilder(marshaller);
    }

    public SerializationContextBuilder register(SerializationContextInitializer var1);

    default public SerializationContextBuilder register(Iterable<? extends SerializationContextInitializer> initializers) {
        for (SerializationContextInitializer serializationContextInitializer : initializers) {
            this.register(serializationContextInitializer);
        }
        return this;
    }

    public SerializationContextBuilder load(ClassLoader var1);

    public SerializationContextBuilder require(ClassLoader var1);

    public ImmutableSerializationContext build();

    public static class DefaultSerializationContextBuilder
    implements SerializationContextBuilder {
        private static final String PROTOSTREAM_BASE_PACKAGE_NAME = BaseMarshaller.class.getPackage().getName();
        private final SerializationContext context = new DefaultSerializationContext();

        DefaultSerializationContextBuilder(ClassLoaderMarshaller marshaller) {
            this.register(new LangSerializationContextInitializer(marshaller));
            this.register(new AnySerializationContextInitializer());
            this.register(new MathSerializationContextInitializer());
            this.register(new NetSerializationContextInitializer());
            this.register(new TimeSerializationContextInitializer());
            this.register(new SQLSerializationContextInitializer());
            this.register(new UtilSerializationContextInitializer());
            this.register(new AtomicSerializationContextInitializer());
            this.register(new ConcurrentSerializationContextInitializer());
            this.register(new MarshallingSerializationContextInitializer());
        }

        @Override
        public SerializationContextBuilder register(SerializationContextInitializer initializer) {
            initializer.registerSchema(this.context);
            initializer.registerMarshallers(this.context);
            return this;
        }

        @Override
        public SerializationContextBuilder load(ClassLoader loader) {
            this.tryLoadAll(loader);
            return this;
        }

        @Override
        public SerializationContextBuilder require(ClassLoader loader) {
            if (!this.tryLoadAll(loader)) {
                throw new NoSuchElementException();
            }
            return this;
        }

        private boolean tryLoadAll(ClassLoader loader) {
            boolean loaded = this.tryLoad(loader);
            boolean loadedNative = this.tryLoadNative(loader);
            return loaded || loadedNative;
        }

        private boolean tryLoad(ClassLoader loader) {
            List<SerializationContextInitializer> loaded = Reflect.loadAll(SerializationContextInitializer.class, loader);
            if (loaded.isEmpty()) {
                return false;
            }
            LinkedList<SerializationContextInitializer> unregistered = new LinkedList<SerializationContextInitializer>(loaded);
            DescriptorParserException exception = null;
            while (!unregistered.isEmpty()) {
                int size = unregistered.size();
                Iterator remaining = unregistered.iterator();
                while (remaining.hasNext()) {
                    SerializationContextInitializer initializer = (SerializationContextInitializer)remaining.next();
                    try {
                        initializer.registerSchema(this.context);
                        initializer.registerMarshallers(this.context);
                        remaining.remove();
                    }
                    catch (DescriptorParserException e) {
                        exception = e;
                    }
                }
                if (exception == null || unregistered.size() != size) continue;
                throw exception;
            }
            return true;
        }

        private boolean tryLoadNative(ClassLoader loader) {
            boolean registered = false;
            for (org.infinispan.protostream.SerializationContextInitializer initializer : Reflect.loadAll(org.infinispan.protostream.SerializationContextInitializer.class, loader)) {
                if (initializer.getClass().getName().startsWith(PROTOSTREAM_BASE_PACKAGE_NAME)) continue;
                initializer.registerSchema((org.infinispan.protostream.SerializationContext)this.context);
                initializer.registerMarshallers((org.infinispan.protostream.SerializationContext)this.context);
                registered = true;
            }
            return registered;
        }

        @Override
        public ImmutableSerializationContext build() {
            return this.context.getImmutableSerializationContext();
        }
    }
}

