/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.wildfly.clustering.marshalling.MarshallerConfigurationBuilder;
import org.wildfly.clustering.marshalling.protostream.AnySerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContext;
import org.wildfly.clustering.marshalling.protostream.LangSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.MarshallingSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.Reflect;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.math.MathSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.net.NetSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.sql.SQLSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.time.TimeSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.util.UtilSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.util.concurrent.ConcurrentSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.util.concurrent.atomic.AtomicSerializationContextInitializer;

public interface SerializationContextBuilder<I>
extends MarshallerConfigurationBuilder<ImmutableSerializationContext, I, SerializationContextBuilder<I>> {
    public static SerializationContextBuilder<SerializationContextInitializer> newInstance(ClassLoaderMarshaller marshaller) {
        return new DefaultSerializationContextBuilder(marshaller);
    }

    public static SerializationContextBuilder<org.infinispan.protostream.SerializationContextInitializer> newInstance() {
        return new NativeSerializationContextBuilder();
    }

    public static class DefaultSerializationContextBuilder
    implements SerializationContextBuilder<SerializationContextInitializer> {
        private static final String PROTOSTREAM_BASE_PACKAGE_NAME = BaseMarshaller.class.getPackage().getName();
        private final SerializationContext context = new DefaultSerializationContext();

        DefaultSerializationContextBuilder(ClassLoaderMarshaller marshaller) {
            this.register(new LangSerializationContextInitializer(marshaller));
            this.register(new AnySerializationContextInitializer());
            this.register(new MathSerializationContextInitializer());
            this.register(new NetSerializationContextInitializer());
            this.register(new TimeSerializationContextInitializer());
            this.register(new SQLSerializationContextInitializer());
            this.register(new UtilSerializationContextInitializer());
            this.register(new AtomicSerializationContextInitializer());
            this.register(new ConcurrentSerializationContextInitializer());
            this.register(new MarshallingSerializationContextInitializer());
        }

        public SerializationContextBuilder<SerializationContextInitializer> register(SerializationContextInitializer initializer) {
            initializer.registerSchema(this.context);
            initializer.registerMarshallers(this.context);
            return this;
        }

        public SerializationContextBuilder<SerializationContextInitializer> load(ClassLoader loader) {
            this.loadWildFly(loader);
            this.loadNative(loader);
            return this;
        }

        private void loadWildFly(ClassLoader loader) {
            List<SerializationContextInitializer> loaded = Reflect.loadAll(SerializationContextInitializer.class, loader);
            if (!loaded.isEmpty()) {
                LinkedList<SerializationContextInitializer> unregistered = new LinkedList<SerializationContextInitializer>(loaded);
                DescriptorParserException exception = null;
                while (!unregistered.isEmpty()) {
                    int size = unregistered.size();
                    Iterator remaining = unregistered.iterator();
                    while (remaining.hasNext()) {
                        SerializationContextInitializer initializer = (SerializationContextInitializer)remaining.next();
                        try {
                            this.register(initializer);
                            remaining.remove();
                        }
                        catch (DescriptorParserException e) {
                            exception = e;
                        }
                    }
                    if (exception == null || unregistered.size() != size) continue;
                    throw exception;
                }
            }
        }

        private void loadNative(ClassLoader loader) {
            for (org.infinispan.protostream.SerializationContextInitializer initializer : Reflect.loadAll(org.infinispan.protostream.SerializationContextInitializer.class, loader)) {
                if (initializer.getClass().getName().startsWith(PROTOSTREAM_BASE_PACKAGE_NAME)) continue;
                initializer.registerSchema((org.infinispan.protostream.SerializationContext)this.context);
                initializer.registerMarshallers((org.infinispan.protostream.SerializationContext)this.context);
            }
        }

        public ImmutableSerializationContext build() {
            return this.context.getImmutableSerializationContext();
        }
    }

    public static class NativeSerializationContextBuilder
    implements SerializationContextBuilder<org.infinispan.protostream.SerializationContextInitializer> {
        private final org.infinispan.protostream.SerializationContext context = ProtobufUtil.newSerializationContext();

        public SerializationContextBuilder<org.infinispan.protostream.SerializationContextInitializer> register(org.infinispan.protostream.SerializationContextInitializer initializer) {
            initializer.registerSchema(this.context);
            initializer.registerMarshallers(this.context);
            return this;
        }

        public SerializationContextBuilder<org.infinispan.protostream.SerializationContextInitializer> load(ClassLoader loader) {
            for (org.infinispan.protostream.SerializationContextInitializer initializer : Reflect.loadAll(org.infinispan.protostream.SerializationContextInitializer.class, loader)) {
                this.register(initializer);
            }
            return this;
        }

        public ImmutableSerializationContext build() {
            return this.context;
        }
    }
}

