/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;

public abstract class AbstractSerializationContextInitializer
implements SerializationContextInitializer {
    private final String resourceName;
    private final ClassLoader loader;

    protected AbstractSerializationContextInitializer() {
        this.resourceName = this.getClass().getPackage().getName() + ".proto";
        this.loader = this.getClass().getClassLoader();
    }

    protected AbstractSerializationContextInitializer(String resourceName) {
        this.resourceName = resourceName;
        this.loader = this.getClass().getClassLoader();
    }

    protected AbstractSerializationContextInitializer(String resourceName, Class<?> containingClass) {
        this.resourceName = resourceName;
        this.loader = containingClass.getClassLoader();
    }

    @Override
    public void registerSchema(SerializationContext context) {
        try {
            context.registerProtoFiles(FileDescriptorSource.fromResources((ClassLoader)this.loader, (String[])new String[]{this.resourceName}));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (DescriptorParserException e) {
            try {
                context.unregisterProtoFile(this.resourceName);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String toString() {
        return this.resourceName;
    }
}

