/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.util.AbstractCollectionMarshaller;

public class CollectionMarshaller<E, T extends Collection<E>>
extends AbstractCollectionMarshaller<E, T> {
    private final Supplier<T> factory;

    public CollectionMarshaller(Supplier<T> factory) {
        super(((Collection)factory.get()).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Collection collection = (Collection)this.factory.get();
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    Object element = reader.readAny();
                    collection.add(element);
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (T)collection;
    }
}

